package com.biz.crm.tpm.business.budget.controls.config.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.budget.controls.config.local.entity.DimensionControls;
import com.biz.crm.tpm.business.budget.controls.config.sdk.dto.BasicInformationQueryBudgetItemsDto;
import com.biz.crm.tpm.business.budget.controls.config.sdk.dto.DimensionControlsDto;
import com.biz.crm.tpm.business.budget.controls.config.sdk.vo.DimensionControlsVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.security.core.parameters.P;

import java.util.List;

/**
 * (DimensionControlsVo)表mybatis访问层
 *
 * @author makejava
 * @since 2022-11-03 17:06:06
 */
public interface DimensionControlsMapper extends BaseMapper<DimensionControls> {

    /**
     * 分页查询所有数据
     *
     * @param page 分页对象
     * @param dto  查询实体
     * @return 所有数据
     */
    Page<DimensionControlsVo> findByConditions(Page<DimensionControlsVo> page, @Param("dto") DimensionControlsDto dto);


    /**
     * 通过dto查询预算管理对象
     */
    DimensionControlsDto findBudgetManagement(@Param("dto") BasicInformationQueryBudgetItemsDto dto);

    /**
     * 查询预算管控
     * @param dto
     * @return {@link List}<{@link DimensionControlsVo}>
     */
    List<DimensionControlsVo> findByDimensionControlsDto(@Param("dto") DimensionControlsDto dto);
}
