package com.biz.crm.tpm.business.budget.controls.config.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.budget.controls.config.local.entity.BudgetProject;
import com.biz.crm.tpm.business.budget.controls.config.local.entity.DimensionControls;
import com.biz.crm.tpm.business.budget.controls.config.local.entity.RulesEnact;
import com.biz.crm.tpm.business.budget.controls.config.local.mapper.DimensionControlsMapper;
import com.biz.crm.tpm.business.budget.controls.config.sdk.dto.BasicInformationQueryBudgetItemsDto;
import com.biz.crm.tpm.business.budget.controls.config.sdk.dto.DimensionControlsDto;
import com.biz.crm.tpm.business.budget.controls.config.sdk.enums.DimensionControlsTypeEnum;
import com.biz.crm.tpm.business.budget.controls.config.sdk.vo.DimensionControlsVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * (DimensionControlsVo)表数据库访问层
 *
 * @author makejava
 * @since 2022-11-03 17:06:39
 */

@Component
public class DimensionControlsRepository extends ServiceImpl<DimensionControlsMapper, DimensionControls> {

    @Autowired
    private DimensionControlsMapper dimensionControlsMapper;

    @Autowired
    private BudgetProjectRepository budgetProjectRepository;

    @Autowired
    private RulesEnactRepository rulesEnactRepository;


    /**
     * 分页查询数据
     *
     * @param pageable             分页对象
     * @param dimensionControlsDto 实体对象
     * @return
     */
    public Page<DimensionControlsVo> findByConditions(Pageable pageable, DimensionControlsDto dimensionControlsDto) {
        if (pageable == null) {
            pageable = PageRequest.of(1, 50);
        }
        dimensionControlsDto.setTenantCode(TenantUtils.getTenantCode());
        Page<DimensionControlsVo> page = new Page<DimensionControlsVo>(pageable.getPageNumber(), pageable.getPageSize());
        return dimensionControlsMapper.findByConditions(page, dimensionControlsDto);
    }


    /**
     * 根据主键、是否编辑页面标记查询预算管理
     *
     * @param id
     * @param delFlag 标识是否为编辑页面（Y：是，N：否）
     * @return com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo
     * @author huojia
     * @date 2022/11/1 21:14
     **/
    public DimensionControls getById(String id, String delFlag) {
        if (StringUtils.isEmpty(id)) {
            return null;
        }
        return this.lambdaQuery()
                .eq(DimensionControls::getId, id)
                .eq(DimensionControls::getTenantCode, TenantUtils.getTenantCode())
                .one();
    }


    /**
     * 通过controlsConfigCode获取DimensionControls的数据
     */
    public DimensionControls getConfigCode(String controlsConfigCode) {
        return this.lambdaQuery().eq(DimensionControls::getControlsConfigCode, controlsConfigCode)
                .eq(DimensionControls::getDelFlag,DelFlagStatusEnum.NORMAL.getCode())
                .eq(DimensionControls::getTenantCode, TenantUtils.getTenantCode())
                .one();
    }

    /**
     * 通过dto查询预算管理对象
     */
    public DimensionControlsDto findBudgetManagement(BasicInformationQueryBudgetItemsDto dto) {
        return dimensionControlsMapper.findBudgetManagement(dto);
    }

    public void deleteByYearBudgetId(String controlsById) {
        if (StringUtils.isEmpty(controlsById)) {
            return;
        }
        DimensionControls dimensionControls = this.getById(controlsById);
        if (ObjectUtils.isEmpty(dimensionControls)) {
            throw new RuntimeException("来源数据数据不存在！");
        }
        //根据type_coding查询字段
        List<BudgetProject> result1 = budgetProjectRepository.getcontrolsConfigCode(dimensionControls.getControlsConfigCode());
        if (!CollectionUtils.isEmpty(result1)) {
            result1.forEach(r1 -> {
                r1.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            });
            this.budgetProjectRepository.updateBatchById(result1);
        }
        //根据type_coding查询字段
        List<RulesEnact> result2 = rulesEnactRepository.getcontrolsConfigCode(dimensionControls.getControlsConfigCode());
        if (!CollectionUtils.isEmpty(result2)) {
            result2.forEach(r2 -> {
                r2.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            });
            this.rulesEnactRepository.updateBatchById(result2);
        }
    }

    /**
     * 条件查询
     *
     * @author huojia
     * @date 2022/12/27 16:25
     * @param dimensionControlsDto
     * @return java.util.List<com.biz.crm.tpm.business.budget.controls.config.local.entity.DimensionControls>
     **/
    public List<DimensionControls> listByConditions(DimensionControlsDto dimensionControlsDto) {
        if (StringUtils.isEmpty(dimensionControlsDto.getControlType())) {
            return null;
        }
        return this.lambdaQuery()
                .eq(DimensionControls::getControlType, dimensionControlsDto.getControlType())
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(UuidFlagOpEntity::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
                .list();
    }

    /**
     *
     * 删除主表数据
     * @param dimensionControls
     */
    public void deleteById(DimensionControls dimensionControls) {
        if (ObjectUtils.isEmpty(dimensionControls)) {
           throw new RuntimeException("数据来源不对");
        }
         DimensionControls dimensionControls1 = this.lambdaQuery()
                .eq(DimensionControls::getId, dimensionControls.getId())
                .eq(DimensionControls::getTenantCode, TenantUtils.getTenantCode())
                .one();
           this.removeById(dimensionControls1);
    }

    /**
     * 查询预算管控
     * @param dto
     * @return {@link List}<{@link DimensionControlsVo}>
     */
    public List<DimensionControlsVo> findByDimensionControlsDto(DimensionControlsDto dto) {
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.dimensionControlsMapper.findByDimensionControlsDto(dto);
    }

    /**
     * 根据条件查询预算管控
     * @param dto
     * @return {@link List}<{@link DimensionControlsVo}>
     */
    public List<DimensionControls> getControlsByConditions(DimensionControlsDto dto) {
        Validate.notEmpty(dto.getBusinessFormatCode(), "业态不能为空");
        Validate.notEmpty(dto.getBusinessUnitCode(), "业务单元不能为空");
//        Validate.notEmpty(dto.getOrgCode(), "部门不能为空");
        if(StringUtils.isNotBlank(dto.getOrgCode())){
            return this.lambdaQuery()
                    .eq(DimensionControls::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                    .eq(DimensionControls::getTenantCode, TenantUtils.getTenantCode())
                    .eq(DimensionControls::getBusinessFormatCode, dto.getBusinessFormatCode())
                    .eq(DimensionControls::getBusinessUnitCode, dto.getBusinessUnitCode())
                    .eq(DimensionControls::getOrgCode, dto.getOrgCode())
                    .eq(DimensionControls::getControlType, DimensionControlsTypeEnum.DIMENSION_CONTROL.getCode())
                    .ne(StringUtils.isNotBlank(dto.getId()), DimensionControls::getId, dto.getId())
                    .list();
        }else {
            return this.lambdaQuery()
                    .eq(DimensionControls::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                    .eq(DimensionControls::getTenantCode, TenantUtils.getTenantCode())
                    .eq(DimensionControls::getBusinessFormatCode, dto.getBusinessFormatCode())
                    .eq(DimensionControls::getBusinessUnitCode, dto.getBusinessUnitCode())
                    .isNull(DimensionControls::getOrgCode)
                    .eq(DimensionControls::getControlType, DimensionControlsTypeEnum.DIMENSION_CONTROL.getCode())
                    .ne(StringUtils.isNotBlank(dto.getId()), DimensionControls::getId, dto.getId())
                    .list();
        }
    }
}
