package com.biz.crm.tpm.business.budget.controls.config.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.budget.controls.config.local.entity.BudgetProject;
import com.biz.crm.tpm.business.budget.controls.config.local.entity.RulesEnact;
import com.biz.crm.tpm.business.budget.controls.config.local.mapper.RulesEnactMapper;
import com.biz.crm.tpm.business.budget.controls.config.sdk.vo.BudgetProjectVo;
import com.biz.crm.tpm.business.budget.controls.config.sdk.vo.RulesEnactVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;


/**
 * (RulesEnactVo)表数据库访问层
 *
 * @author makejava
 * @since 2022-11-03 17:06:39
 */

@Component
public class RulesEnactRepository extends ServiceImpl<RulesEnactMapper, RulesEnact> {

    /**
     * 通过controlsConfigCode查询选择规则制定表
     */
    public List<RulesEnact> findBycontrolsConfigCode(String delFlag) {
        return this.lambdaQuery().eq(RulesEnact::getDelFlag, delFlag).list();
    }


    /**
     * 根据编码类型删除管控配置编码
     */
    public void deleteByControlsConfigCode(String controlsConfigCode) {
        if (StringUtils.isEmpty(controlsConfigCode)) {
            return;
        }
        List<RulesEnact> list = this.lambdaQuery().eq(RulesEnact::getControlsConfigCode, controlsConfigCode).list();
        if (!org.springframework.util.CollectionUtils.isEmpty(list)) {
            list.forEach(rulesEnact -> {
                rulesEnact.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            });
            this.updateBatchById(list);
        }
    }

    /**
     * 根据主键、是否编辑页面标记查询预算管理
     *
     * @param delFlag 标识是否为编辑页面（Y：是，N：否）
     * @date 2022/11/1 21:14
     **/
    public List<RulesEnact> finByByControlsConfigCodeAndDelFlag(String delFlag, String controlsConfigCode) {
        if (StringUtils.isEmpty(delFlag)) {
            return null;
        }
        return this.lambdaQuery().eq(RulesEnact::getDelFlag, delFlag).eq(RulesEnact::getControlsConfigCode, controlsConfigCode).list();
    }

    /**
     * 查详情
     * */
    public List<RulesEnact> getcontrolsConfigCode(String controlsConfigCode) {
        return this.lambdaQuery().eq(RulesEnact::getControlsConfigCode, controlsConfigCode).list();
    }

    /**
     * 查询维度公式
     * @param controlsConfigCodes
     * @return {@link List}<{@link RulesEnactVo}>
     */
    public List<RulesEnactVo> findByControlsConfigCodes(List<String> controlsConfigCodes) {
        return this.baseMapper.findByControlsConfigCodes(controlsConfigCodes, TenantUtils.getTenantCode());
    }
}
