package com.biz.crm.tpm.business.budget.controls.config.local.service.internal;
import com.biz.crm.tpm.business.budget.controls.config.local.entity.RulesEnact;
import com.biz.crm.tpm.business.budget.controls.config.local.repository.RulesEnactRepository;
import com.biz.crm.tpm.business.budget.controls.config.local.util.ListConverterUtils;
import com.biz.crm.tpm.business.budget.controls.config.sdk.dto.RulesEnactDto;
import com.biz.crm.tpm.business.budget.controls.config.sdk.service.RulesEnactService;
import com.biz.crm.tpm.business.budget.controls.config.sdk.vo.RulesEnactVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;

/**
 * (RulesEnactServiceImpl)表服务实现类
 *
 * @author makejava
 * @since 2022-11-03 17:06:02
 */
@Slf4j
@Service("rulesEnactService")
public class RulesEnactServiceImpl implements RulesEnactService {

    @Autowired
    private RulesEnactRepository rulesEnactRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;


    @Override
    public void create(RulesEnactDto rulesEnactDto, String promotionCode) {


        /**新增管控配置编码*/
        rulesEnactDto.setControlsConfigCode(promotionCode);

        RulesEnact rulesEnact = this.nebulaToolkitService.copyObjectByWhiteList(rulesEnactDto, RulesEnact.class, LinkedHashSet.class, ArrayList.class);

        rulesEnactRepository.saveOrUpdate(rulesEnact);
    }


    /**
     * 修改规则制定表数据
     */
    @Override
    public RulesEnactVo update(RulesEnactDto dto) {
        List<RulesEnact> formeResult = this.rulesEnactRepository.getcontrolsConfigCode(dto.getControlsConfigCode());
        if (ObjectUtils.isEmpty(formeResult)) {
            throw new RuntimeException("修改数据失败，原数据不存在！");
        }
        RulesEnact value = this.nebulaToolkitService.copyObjectByWhiteList(dto, RulesEnact.class, HashSet.class, ArrayList.class);
        this.rulesEnactRepository.saveOrUpdate(value);
        RulesEnactVo rulesEnactVo = this.nebulaToolkitService.copyObjectByWhiteList(dto, RulesEnactVo.class, HashSet.class, ArrayList.class);
        return rulesEnactVo;
    }

    /**
     * 根据编码类型删除管控配置编码
     */
    @Override
    public void deleteByControlsConfigCode(String controlsConfigCode) {
        this.rulesEnactRepository.deleteByControlsConfigCode(controlsConfigCode);
    }

    /**
     * 批量新增维度信息表
     */
    @Override
    public void savaBatch(List<RulesEnactDto> dto) {
        for (RulesEnactDto d : dto) {
            d.setId(null);
        }

        if (dto != null && dto.size() > 0) {
            ArrayList<RulesEnact> productEntityList =
                    Lists.newArrayList(nebulaToolkitService.copyCollectionByWhiteList(dto, RulesEnactDto.class, RulesEnact.class, HashSet.class, ArrayList.class));
            rulesEnactRepository.saveOrUpdateBatch(productEntityList);
        }
    }

    /**
     * 根据主键、是否编辑页面标记查询预算管理
     *
     * @param delFlag 标识是否为编辑页面（Y：是，N：否）
     * @date 2022/11/1 21:14
     **/
    @Override
    public List<RulesEnactVo> finByByControlsConfigCodeAndDelFlag(String delFlag, String controlsConfigCode) {
        List<RulesEnact> result = this.rulesEnactRepository.finByByControlsConfigCodeAndDelFlag(delFlag, controlsConfigCode);
        ListConverterUtils converterUtils = new ListConverterUtils(RulesEnactVo.class);
        List<RulesEnactVo> arrayList = converterUtils.converterList(result);
        return arrayList;
    }

    /**
     * 查询维度公式
     * @param controlsConfigCodes
     * @return {@link List}<{@link RulesEnactVo}>
     */
    @Override
    public List<RulesEnactVo> findByControlsConfigCodes(List<String> controlsConfigCodes) {
        if(CollectionUtils.isEmpty(controlsConfigCodes)){
            return Lists.newArrayList();
        }
        return this.rulesEnactRepository.findByControlsConfigCodes(controlsConfigCodes);
    }
}
