/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.controls.config.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.budget.controls.config.sdk.dto.BasicInformationQueryBudgetItemsDto;
import com.biz.crm.tpm.business.budget.controls.config.sdk.dto.BudgetProjectDto;
import com.biz.crm.tpm.business.budget.controls.config.sdk.service.BudgetProjectService;
import com.biz.crm.tpm.business.budget.controls.config.sdk.vo.BudgetProjectVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/budgetProject"})
@Api(tags={"\u9009\u62e9\u9884\u7b97\u9879\u76ee"})
public class BudgetProjectController {
    private static final Logger log = LoggerFactory.getLogger(BudgetProjectController.class);
    @Autowired
    private BudgetProjectService projectService;

    @ApiOperation(value="\u901a\u8fc7\u57fa\u672c\u4fe1\u606f\u67e5\u8be2\u9884\u7b97\u9879\u76ee\u63a5\u53e3")
    @PostMapping
    public Result<List<BudgetProjectVo>> basicInformationQueryBudgetItems(@ApiParam(name="dto", value="\u9009\u62e9\u9884\u7b97\u9879\u76ee") @RequestBody @Valid BasicInformationQueryBudgetItemsDto dto) {
        try {
            List result = this.projectService.basicInformationQueryBudgetItems(dto);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<BudgetProjectVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dimensionBudget", value="\u9884\u7b97\u7ba1\u7406\u914d\u7f6e\u8868") BudgetProjectDto dto) {
        try {
            Page page = this.projectService.findByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

