/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.controls.config.local.dataview;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.tpm.business.budget.controls.config.local.repository.BudgetProjectRepository;
import com.biz.crm.tpm.business.budget.controls.config.sdk.service.BudgetProjectService;
import com.biz.crm.tpm.business.budget.controls.config.sdk.vo.BudgetProjectVo;
import com.bizunited.nebula.europa.database.register.sdk.service.MnDataviewRegister;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteExternalRequest;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteParameter;
import com.bizunited.nebula.europa.database.sdk.strategy.ParameterOperatorBindingStrategy;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteParameter;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DimensionControlsDataViewRegister
implements MnDataviewRegister {
    @Autowired(required=false)
    @Qualifier(value="inParameterOperatorBindingStrategy")
    private ParameterOperatorBindingStrategy inParameterOperatorBindingStrategy;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private BudgetProjectService budgetProjectService;
    @Autowired(required=false)
    private BudgetProjectRepository budgetProjectRepository;

    public String code() {
        return "tpm_budget_controls_config_data_view";
    }

    public String desc() {
        return "TPM \u9884\u7b97\u7ba1\u63a7\u914d\u7f6e\u8bbe\u7f6e\u6570\u636e\u89c6\u56fe";
    }

    public String buildSql() {
        return "SELECT t.*,'' as sales_org_name ,\n'' as budget_item_level,\n'' as budget_item_code,\n'' as budget_item_name\nFROM tpm_dimension_controls t  WHERE  t.del_flag = '" + EnableStatusEnum.ENABLE.getCode() + "'   AND t.tenant_code = :tenantCode ";
    }

    public Object customBindingFieldValue(ExecuteParameter executeParameter, DatabaseExecuteExternalRequest databaseExecuteExternalRequest) {
        if (!(executeParameter instanceof DatabaseExecuteParameter)) {
            return null;
        }
        DatabaseExecuteParameter databaseExecuteParameter = (DatabaseExecuteParameter)executeParameter;
        String paramName = databaseExecuteParameter.getParamName();
        Object value = databaseExecuteExternalRequest.getAttribute(paramName);
        if (value == null) {
            return null;
        }
        String valueStr = String.valueOf(value);
        if ("sales_org_name".equals(databaseExecuteParameter.getTargetFieldName())) {
            return this.salesOrgNameQuery(databaseExecuteParameter, valueStr);
        }
        if ("budget_item_level".equals(databaseExecuteParameter.getTargetFieldName())) {
            return this.budgetItemLevelQuery(databaseExecuteParameter, valueStr);
        }
        if ("budget_item_code".equals(databaseExecuteParameter.getTargetFieldName())) {
            return this.budgetItemCodeQuery(databaseExecuteParameter, valueStr);
        }
        if ("budget_item_name".equals(databaseExecuteParameter.getTargetFieldName())) {
            return this.budgetItemNameQuery(databaseExecuteParameter, valueStr);
        }
        return value;
    }

    private Object budgetItemNameQuery(DatabaseExecuteParameter databaseExecuteParameter, String valueStr) {
        String targetAlias = databaseExecuteParameter.getTargetAlias();
        String targetTableName = databaseExecuteParameter.getTargetTableName();
        String targetFieldName = "controls_config_code";
        String parameterName = databaseExecuteParameter.getParamName();
        String expression = this.inParameterOperatorBindingStrategy.expression(targetAlias, targetTableName, targetFieldName, parameterName);
        databaseExecuteParameter.setTargetOpExpression(expression);
        ArrayList controlsConfigCodeList = Lists.newArrayList((Object[])new String[]{"_"});
        List<String> budgetItemNameList = Arrays.asList(valueStr.split("[, \uff0c]"));
        List byBudgetItemNames = this.budgetProjectService.findByBudgetItemNames(budgetItemNameList);
        List collect = byBudgetItemNames.stream().map(BudgetProjectVo::getControlsConfigCode).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collect)) {
            controlsConfigCodeList.addAll(collect);
        }
        return controlsConfigCodeList;
    }

    private Object budgetItemCodeQuery(DatabaseExecuteParameter databaseExecuteParameter, String valueStr) {
        String targetAlias = databaseExecuteParameter.getTargetAlias();
        String targetTableName = databaseExecuteParameter.getTargetTableName();
        String targetFieldName = "controls_config_code";
        String parameterName = databaseExecuteParameter.getParamName();
        String expression = this.inParameterOperatorBindingStrategy.expression(targetAlias, targetTableName, targetFieldName, parameterName);
        databaseExecuteParameter.setTargetOpExpression(expression);
        ArrayList controlsConfigCodeList = Lists.newArrayList((Object[])new String[]{"_"});
        List<String> budgetItemCodeList = Arrays.asList(valueStr.split("[, \uff0c]"));
        List<BudgetProjectVo> byBudgetItemNames = this.budgetProjectRepository.findByBudgetItemCodes(budgetItemCodeList);
        List collect = byBudgetItemNames.stream().map(BudgetProjectVo::getControlsConfigCode).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collect)) {
            controlsConfigCodeList.addAll(collect);
        }
        return controlsConfigCodeList;
    }

    private Object budgetItemLevelQuery(DatabaseExecuteParameter databaseExecuteParameter, String valueStr) {
        String targetAlias = databaseExecuteParameter.getTargetAlias();
        String targetTableName = databaseExecuteParameter.getTargetTableName();
        String targetFieldName = "controls_config_code";
        String parameterName = databaseExecuteParameter.getParamName();
        String expression = this.inParameterOperatorBindingStrategy.expression(targetAlias, targetTableName, targetFieldName, parameterName);
        databaseExecuteParameter.setTargetOpExpression(expression);
        ArrayList controlsConfigCodeList = Lists.newArrayList((Object[])new String[]{"_"});
        List<String> budgetItemLevelList = Arrays.asList(valueStr.split("[, \uff0c]"));
        List<BudgetProjectVo> byBudgetItemNames = this.budgetProjectRepository.findByBudgetItemLevels(budgetItemLevelList);
        List collect = byBudgetItemNames.stream().map(BudgetProjectVo::getControlsConfigCode).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collect)) {
            controlsConfigCodeList.addAll(collect);
        }
        return controlsConfigCodeList;
    }

    private Object salesOrgNameQuery(DatabaseExecuteParameter databaseExecuteParameter, String valueStr) {
        String targetAlias = databaseExecuteParameter.getTargetAlias();
        String targetTableName = databaseExecuteParameter.getTargetTableName();
        String targetFieldName = "market_organization";
        String parameterName = databaseExecuteParameter.getParamName();
        String expression = this.inParameterOperatorBindingStrategy.expression(targetAlias, targetTableName, targetFieldName, parameterName);
        databaseExecuteParameter.setTargetOpExpression(expression);
        ArrayList salesOrgCode = Lists.newArrayList((Object[])new String[]{"_"});
        List bySalesOrgNames = this.salesOrgVoService.findListBySalesOrgName(valueStr);
        List codeList = bySalesOrgNames.stream().map(SalesOrgVo::getSalesOrgCode).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(codeList)) {
            salesOrgCode.addAll(codeList);
        }
        return salesOrgCode;
    }
}

