/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.controls.config.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.budget.controls.config.local.entity.BudgetProject;
import com.biz.crm.tpm.business.budget.controls.config.local.mapper.BudgetProjectMapper;
import com.biz.crm.tpm.business.budget.controls.config.sdk.dto.BudgetProjectDto;
import com.biz.crm.tpm.business.budget.controls.config.sdk.vo.BudgetProjectVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BudgetProjectRepository
extends ServiceImpl<BudgetProjectMapper, BudgetProject> {
    @Autowired
    private BudgetProjectMapper budgetProjectMapper;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public List<BudgetProject> getcontrolsConfigCode(String delFlag) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)delFlag)).list();
    }

    public Page<BudgetProjectVo> findByConditions(Pageable pageable, BudgetProjectDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)1, (int)50);
        }
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.budgetProjectMapper.findByConditions((Page<BudgetProjectVo>)page, dto);
    }

    public List<BudgetProject> findBycontrolsConfigCode(String controlsConfigCode) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(BudgetProject::getControlsConfigCode, (Object)controlsConfigCode)).list();
    }

    public void deleteByControlsConfigCode(String controlsConfigCode) {
        if (StringUtils.isEmpty((CharSequence)controlsConfigCode)) {
            return;
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(BudgetProject::getControlsConfigCode, (Object)controlsConfigCode)).list();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            list.forEach(budgetProject -> budgetProject.setDelFlag(DelFlagStatusEnum.DELETE.getCode()));
            this.updateBatchById(list);
        }
    }

    public List<BudgetProject> finByByControlsConfigCodeAndDelFlag(String delFlag, String controlsConfigCode) {
        if (StringUtils.isEmpty((CharSequence)delFlag)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)delFlag)).eq(BudgetProject::getControlsConfigCode, (Object)controlsConfigCode)).list();
    }

    public List<BudgetProject> listByControlsConfigCodeList(List<String> controlsConfigCodeList) {
        if (CollectionUtils.isEmpty(controlsConfigCodeList)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(BudgetProject::getControlsConfigCode, controlsConfigCodeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<BudgetProject> getByConfigCodesAndItemCodes(List<String> controlsCodes, List<String> codes) {
        Validate.notEmpty(controlsCodes, (String)"\u9884\u7b97\u7ba1\u63a7\u7f16\u7801\u5217\u8868\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty(codes, (String)"\u9884\u7b97\u9879\u76ee\u7f16\u7801\u5217\u8868\u4e3a\u7a7a", (Object[])new Object[0]);
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(BudgetProject::getControlsConfigCode, controlsCodes)).in(BudgetProject::getBudgetItemCode, codes)).list();
    }

    public List<BudgetProjectVo> findByBudgetItemNames(List<String> budgetItemNameList) {
        Validate.notEmpty(budgetItemNameList, (String)"\u9884\u7b97\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(BudgetProject::getBudgetItemName, budgetItemNameList)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, BudgetProject.class, BudgetProjectVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<BudgetProjectVo> findByBudgetItemCodes(List<String> budgetItemCodeList) {
        Validate.notEmpty(budgetItemCodeList, (String)"\u9884\u7b97\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(BudgetProject::getBudgetItemCode, budgetItemCodeList)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, BudgetProject.class, BudgetProjectVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<BudgetProjectVo> findByBudgetItemLevels(List<String> budgetItemLevelList) {
        Validate.notEmpty(budgetItemLevelList, (String)"\u9884\u7b97\u9879\u76ee\u5c42\u7ea7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(BudgetProject::getBudgetItemHierarchy, budgetItemLevelList)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, BudgetProject.class, BudgetProjectVo.class, HashSet.class, ArrayList.class, new String[0]);
    }
}

