/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.controls.config.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.budget.controls.config.local.entity.BudgetProject;
import com.biz.crm.tpm.business.budget.controls.config.local.entity.DimensionControls;
import com.biz.crm.tpm.business.budget.controls.config.local.entity.RulesEnact;
import com.biz.crm.tpm.business.budget.controls.config.local.mapper.DimensionControlsMapper;
import com.biz.crm.tpm.business.budget.controls.config.local.repository.BudgetProjectRepository;
import com.biz.crm.tpm.business.budget.controls.config.local.repository.RulesEnactRepository;
import com.biz.crm.tpm.business.budget.controls.config.sdk.dto.BasicInformationQueryBudgetItemsDto;
import com.biz.crm.tpm.business.budget.controls.config.sdk.dto.DimensionControlsDto;
import com.biz.crm.tpm.business.budget.controls.config.sdk.enums.DimensionControlsTypeEnum;
import com.biz.crm.tpm.business.budget.controls.config.sdk.vo.DimensionControlsVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DimensionControlsRepository
extends ServiceImpl<DimensionControlsMapper, DimensionControls> {
    @Autowired
    private DimensionControlsMapper dimensionControlsMapper;
    @Autowired
    private BudgetProjectRepository budgetProjectRepository;
    @Autowired
    private RulesEnactRepository rulesEnactRepository;

    public Page<DimensionControlsVo> findByConditions(Pageable pageable, DimensionControlsDto dimensionControlsDto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)1, (int)50);
        }
        dimensionControlsDto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.dimensionControlsMapper.findByConditions((Page<DimensionControlsVo>)page, dimensionControlsDto);
    }

    public DimensionControls getById(String id, String delFlag) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        return (DimensionControls)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidEntity::getId, (Object)id)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).one());
    }

    public DimensionControls getConfigCode(String controlsConfigCode) {
        return (DimensionControls)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(DimensionControls::getControlsConfigCode, (Object)controlsConfigCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).one());
    }

    public DimensionControlsDto findBudgetManagement(BasicInformationQueryBudgetItemsDto dto) {
        return this.dimensionControlsMapper.findBudgetManagement(dto);
    }

    public void deleteByYearBudgetId(String controlsById) {
        List<RulesEnact> result2;
        if (StringUtils.isEmpty((CharSequence)controlsById)) {
            return;
        }
        DimensionControls dimensionControls = (DimensionControls)((Object)this.getById((Serializable)((Object)controlsById)));
        if (ObjectUtils.isEmpty((Object)((Object)dimensionControls))) {
            throw new RuntimeException("\u6765\u6e90\u6570\u636e\u6570\u636e\u4e0d\u5b58\u5728\uff01");
        }
        List<BudgetProject> result1 = this.budgetProjectRepository.getcontrolsConfigCode(dimensionControls.getControlsConfigCode());
        if (!CollectionUtils.isEmpty(result1)) {
            result1.forEach(r1 -> r1.setDelFlag(DelFlagStatusEnum.DELETE.getCode()));
            this.budgetProjectRepository.updateBatchById(result1);
        }
        if (!CollectionUtils.isEmpty(result2 = this.rulesEnactRepository.getcontrolsConfigCode(dimensionControls.getControlsConfigCode()))) {
            result2.forEach(r2 -> r2.setDelFlag(DelFlagStatusEnum.DELETE.getCode()));
            this.rulesEnactRepository.updateBatchById(result2);
        }
    }

    public List<DimensionControls> listByConditions(DimensionControlsDto dimensionControlsDto) {
        if (StringUtils.isEmpty((CharSequence)dimensionControlsDto.getControlType())) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(DimensionControls::getControlType, (Object)dimensionControlsDto.getControlType())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).list();
    }

    public void deleteById(DimensionControls dimensionControls) {
        if (ObjectUtils.isEmpty((Object)((Object)dimensionControls))) {
            throw new RuntimeException("\u6570\u636e\u6765\u6e90\u4e0d\u5bf9");
        }
        DimensionControls dimensionControls1 = (DimensionControls)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidEntity::getId, (Object)dimensionControls.getId())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).one());
        this.removeById((Serializable)((Object)dimensionControls1));
    }

    public List<DimensionControlsVo> findByDimensionControlsDto(DimensionControlsDto dto) {
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.dimensionControlsMapper.findByDimensionControlsDto(dto);
    }

    public List<DimensionControls> getControlsByConditions(DimensionControlsDto dto) {
        Validate.notEmpty((CharSequence)dto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)dto.getOrgCode())) {
            return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(DimensionControls::getBusinessFormatCode, (Object)dto.getBusinessFormatCode())).eq(DimensionControls::getBusinessUnitCode, (Object)dto.getBusinessUnitCode())).eq(DimensionControls::getOrgCode, (Object)dto.getOrgCode())).eq(DimensionControls::getControlType, (Object)DimensionControlsTypeEnum.DIMENSION_CONTROL.getCode())).ne(StringUtils.isNotBlank((CharSequence)dto.getId()), UuidEntity::getId, (Object)dto.getId())).list();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(DimensionControls::getBusinessFormatCode, (Object)dto.getBusinessFormatCode())).eq(DimensionControls::getBusinessUnitCode, (Object)dto.getBusinessUnitCode())).isNull(DimensionControls::getOrgCode)).eq(DimensionControls::getControlType, (Object)DimensionControlsTypeEnum.DIMENSION_CONTROL.getCode())).ne(StringUtils.isNotBlank((CharSequence)dto.getId()), UuidEntity::getId, (Object)dto.getId())).list();
    }
}

