/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.controls.config.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.budget.controls.config.local.entity.BudgetProject;
import com.biz.crm.tpm.business.budget.controls.config.local.entity.DimensionControls;
import com.biz.crm.tpm.business.budget.controls.config.local.repository.BudgetProjectRepository;
import com.biz.crm.tpm.business.budget.controls.config.local.repository.DimensionControlsRepository;
import com.biz.crm.tpm.business.budget.controls.config.local.util.ListConverterUtils;
import com.biz.crm.tpm.business.budget.controls.config.sdk.dto.BasicInformationQueryBudgetItemsDto;
import com.biz.crm.tpm.business.budget.controls.config.sdk.dto.BudgetProjectDto;
import com.biz.crm.tpm.business.budget.controls.config.sdk.dto.DimensionControlsDto;
import com.biz.crm.tpm.business.budget.controls.config.sdk.service.BudgetProjectService;
import com.biz.crm.tpm.business.budget.controls.config.sdk.service.DimensionControlsService;
import com.biz.crm.tpm.business.budget.controls.config.sdk.vo.BudgetProjectVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="budgetProjectService")
public class BudgetProjectServiceImpl
implements BudgetProjectService {
    private static final Logger log = LoggerFactory.getLogger(BudgetProjectServiceImpl.class);
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private BudgetProjectRepository budgetProjectRepository;
    @Autowired
    private DimensionControlsService dimensionControlsService;
    @Autowired(required=false)
    private DimensionControlsRepository dimensionControlsRepository;

    public void create(BudgetProjectDto budgetProjectDto, String promotionCode) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)budgetProjectDto.getBudgetItemCode()), (String)"\u9884\u7b97\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)budgetProjectDto.getBudgetItemHierarchy()), (String)"\u9884\u7b97\u9879\u76ee\u5c42\u7ea7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)budgetProjectDto.getBudgetItemName()), (String)"\u9884\u7b97\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        budgetProjectDto.setControlsConfigCode(promotionCode);
        BudgetProject budgetItem = (BudgetProject)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)budgetProjectDto, BudgetProject.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        this.budgetProjectRepository.saveOrUpdate((Object)budgetItem);
    }

    public BudgetProjectVo update(BudgetProjectDto dto) {
        List<BudgetProjectVo> formeResult = this.getcontrolsConfigCode(dto.getControlsConfigCode());
        if (ObjectUtils.isEmpty(formeResult)) {
            throw new RuntimeException("\u4fee\u6539\u6570\u636e\u5931\u8d25\uff0c\u539f\u6570\u636e\u4e0d\u5b58\u5728\uff01");
        }
        BudgetProject value = (BudgetProject)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, BudgetProject.class, HashSet.class, ArrayList.class, new String[0]));
        this.budgetProjectRepository.saveOrUpdate((Object)value);
        BudgetProjectVo budgetProjectVo = (BudgetProjectVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, BudgetProjectVo.class, HashSet.class, ArrayList.class, new String[0]);
        return budgetProjectVo;
    }

    public List<BudgetProjectVo> getcontrolsConfigCode(String delFlag) {
        List<BudgetProject> result = this.budgetProjectRepository.getcontrolsConfigCode(delFlag);
        ListConverterUtils<BudgetProject, BudgetProjectVo> converterUtils = new ListConverterUtils<BudgetProject, BudgetProjectVo>(BudgetProjectVo.class);
        List<BudgetProjectVo> arrayList = converterUtils.converterList(result);
        return arrayList;
    }

    public List<BudgetProjectVo> basicInformationQueryBudgetItems(BasicInformationQueryBudgetItemsDto dto) {
        if (ObjectUtils.isEmpty((Object)dto)) {
            throw new RuntimeException("\u67e5\u8be2\u6570\u636e\u4e0d\u4e0d\u5b58\u5728\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)dto.getBusinessFormatCode()) || StringUtils.isEmpty((CharSequence)dto.getBusinessUnitCode()) || StringUtils.isEmpty((CharSequence)dto.getMarketOrganization())) {
            return Lists.newArrayList();
        }
        DimensionControlsDto dimensionControlsDto = this.dimensionControlsService.findBudgetManagement(dto);
        List<BudgetProjectVo> budgetProjectVos = this.getcontrolsConfigCode(dimensionControlsDto.getControlsConfigCode());
        if (ObjectUtils.isEmpty(budgetProjectVos)) {
            throw new RuntimeException("\u67e5\u8be2\u6570\u636e\u4e0d\u5b58\u5728");
        }
        return budgetProjectVos;
    }

    public Page<BudgetProjectVo> findByConditions(Pageable pageable, BudgetProjectDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)1, (int)50);
        }
        if (dto == null) {
            dto = new BudgetProjectDto();
        }
        return this.budgetProjectRepository.findByConditions(pageable, dto);
    }

    public void deleteByControlsConfigCode(String controlsConfigCode) {
        this.budgetProjectRepository.deleteByControlsConfigCode(controlsConfigCode);
    }

    public void savaBatch(List<BudgetProjectDto> dto) {
        for (BudgetProjectDto d : dto) {
            d.setId(null);
        }
        if (dto != null && dto.size() > 0) {
            ArrayList productEntityList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(dto, BudgetProjectDto.class, BudgetProject.class, HashSet.class, ArrayList.class, new String[0]));
            this.budgetProjectRepository.saveOrUpdateBatch(productEntityList);
        }
    }

    public List<BudgetProjectVo> finByByControlsConfigCodeAndDelFlag(String delFlag, String controlsConfigCode) {
        List<BudgetProject> result = this.budgetProjectRepository.finByByControlsConfigCodeAndDelFlag(delFlag, controlsConfigCode);
        ListConverterUtils<BudgetProject, BudgetProjectVo> converterUtils = new ListConverterUtils<BudgetProject, BudgetProjectVo>(BudgetProjectVo.class);
        List<BudgetProjectVo> arrayList = converterUtils.converterList(result);
        return arrayList;
    }

    public List<BudgetProjectVo> listByControlsConfigCodeList(List<String> controlsConfigCodeList) {
        if (CollectionUtils.isEmpty(controlsConfigCodeList)) {
            return null;
        }
        List<BudgetProject> budgetProjects = this.budgetProjectRepository.listByControlsConfigCodeList(controlsConfigCodeList);
        if (CollectionUtils.isEmpty(budgetProjects)) {
            return null;
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(budgetProjects, BudgetProject.class, BudgetProjectVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public void checkRepeat(List<BudgetProjectDto> projectDtos, DimensionControlsDto controlsDto) {
        Validate.notEmpty(projectDtos, (String)"\u9884\u7b97\u9879\u76ee\u5217\u8868\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)controlsDto, (String)"\u9884\u7b97\u7ba1\u63a7\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
        List<String> codes = projectDtos.stream().map(BudgetProjectDto::getBudgetItemCode).collect(Collectors.toList());
        Validate.notEmpty(codes, (String)"\u9884\u7b97\u9879\u76ee\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)controlsDto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)controlsDto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<DimensionControls> list = this.dimensionControlsRepository.getControlsByConditions(controlsDto);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List<String> controlsCodes = list.stream().map(DimensionControls::getControlsConfigCode).collect(Collectors.toList());
        List<BudgetProject> projects = this.budgetProjectRepository.getByConfigCodesAndItemCodes(controlsCodes, codes);
        if (!CollectionUtils.isEmpty(projects)) {
            Validate.isTrue((boolean)false, (String)("\u9884\u7b97\u9879\u76ee[" + projects.get(0).getBudgetItemCode() + "]\u5df2\u5b58\u5728\u5176\u4ed6\u51b2\u7a81\u7ba1\u63a7\u7ef4\u5ea6\uff0c\u8bf7\u786e\u8ba4\uff01"), (Object[])new Object[0]);
        }
    }

    public List<BudgetProjectVo> findByBudgetItemNames(List<String> budgetItemNameList) {
        if (CollectionUtils.isEmpty(budgetItemNameList)) {
            return Lists.newArrayList();
        }
        return this.budgetProjectRepository.findByBudgetItemNames(budgetItemNameList);
    }
}

