/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.controls.config.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.budget.controls.config.local.entity.DimensionControls;
import com.biz.crm.tpm.business.budget.controls.config.local.repository.DimensionControlsRepository;
import com.biz.crm.tpm.business.budget.controls.config.sdk.dto.BasicInformationQueryBudgetItemsDto;
import com.biz.crm.tpm.business.budget.controls.config.sdk.dto.ControlTypeDataDto;
import com.biz.crm.tpm.business.budget.controls.config.sdk.dto.DimensionControlsDto;
import com.biz.crm.tpm.business.budget.controls.config.sdk.dto.log.DimensionControlsLogEventDto;
import com.biz.crm.tpm.business.budget.controls.config.sdk.enums.DimensionControlsTypeEnum;
import com.biz.crm.tpm.business.budget.controls.config.sdk.event.log.DimensionControlsLogEventListener;
import com.biz.crm.tpm.business.budget.controls.config.sdk.service.BudgetProjectService;
import com.biz.crm.tpm.business.budget.controls.config.sdk.service.DimensionControlsService;
import com.biz.crm.tpm.business.budget.controls.config.sdk.service.RulesEnactService;
import com.biz.crm.tpm.business.budget.controls.config.sdk.vo.BudgetProjectVo;
import com.biz.crm.tpm.business.budget.controls.config.sdk.vo.ControlTypeDataVo;
import com.biz.crm.tpm.business.budget.controls.config.sdk.vo.DimensionControlsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="dimensionControlsService")
public class DimensionControlsServiceImpl
implements DimensionControlsService {
    private static final Logger log = LoggerFactory.getLogger(DimensionControlsServiceImpl.class);
    @Autowired
    private DimensionControlsRepository dimensionControlsRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private RulesEnactService rulesEnactService;
    @Autowired(required=false)
    private BudgetProjectService budgetProjectService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired
    private GenerateCodeService generateCodeService;
    private final long REMARK_LENGTH = 400L;
    private final int NAME_LENGTH = 64;

    public Page<DimensionControlsVo> findByConditions(Pageable pageable, DimensionControlsDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)1, (int)50);
        }
        if (dto == null) {
            dto = new DimensionControlsDto();
        }
        if (StringUtils.isBlank((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        if (StringUtils.isBlank((CharSequence)dto.getDelFlag())) {
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }
        return this.dimensionControlsRepository.findByConditions(pageable, dto);
    }

    @Transactional(rollbackFor={Exception.class})
    public DimensionControlsVo create(ControlTypeDataDto dto) {
        DimensionControlsDto dimensionControlsDto = dto.getDimensionControlsDto();
        List rulesEnactDto = dto.getRulesEnactDto();
        List budgetProjectDto = dto.getBudgetProjectDto();
        dimensionControlsDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        if (BooleanEnum.FALSE.getCapital().equals(dimensionControlsDto.getIfRolling())) {
            dimensionControlsDto.setRollingType(null);
        }
        if (StringUtils.isBlank((CharSequence)dimensionControlsDto.getTenantCode())) {
            dimensionControlsDto.setTenantCode(TenantUtils.getTenantCode());
        }
        if (StringUtils.isBlank((CharSequence)dimensionControlsDto.getOrgCode())) {
            dimensionControlsDto.setOrgCode(null);
            dimensionControlsDto.setOrgName(null);
        }
        String ruleCode = "GKPZ";
        String promotionCode = (String)this.generateCodeService.generateCode(ruleCode, 1).get(0);
        Validate.notBlank((CharSequence)promotionCode, (String)"\u4fc3\u9500\u7f16\u53f7\u751f\u6210\u5931\u8d25", (Object[])new Object[0]);
        dimensionControlsDto.setControlsConfigCode(promotionCode);
        dimensionControlsDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        DimensionControls dimensionControls = (DimensionControls)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dimensionControlsDto, DimensionControls.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        this.dimensionControlsRepository.saveOrUpdate((Object)dimensionControls);
        if (dimensionControlsDto.getControlType().equals(DimensionControlsTypeEnum.OVERALL_CONTROL.getCode())) {
            rulesEnactDto.forEach(e -> this.rulesEnactService.create(e, promotionCode));
        }
        if (dimensionControlsDto.getControlType().equals(DimensionControlsTypeEnum.DIMENSION_CONTROL.getCode())) {
            this.budgetProjectService.checkRepeat(budgetProjectDto, dimensionControlsDto);
            budgetProjectDto.forEach(b -> this.budgetProjectService.create(b, promotionCode));
        }
        DimensionControlsVo dimensionControlsVo = (DimensionControlsVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dimensionControls, DimensionControlsVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        DimensionControlsLogEventDto logEventDto = new DimensionControlsLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(dimensionControlsDto);
        SerializableBiConsumer & Serializable onCreate = DimensionControlsLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, DimensionControlsLogEventListener.class, (SerializableBiConsumer)onCreate);
        return dimensionControlsVo;
    }

    public ControlTypeDataVo findById(String id) {
        List arrayList1 = new ArrayList();
        List arrayList2 = new ArrayList();
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        DimensionControls dimensionControls = this.dimensionControlsRepository.getById(id, DelFlagStatusEnum.NORMAL.getCode());
        if (dimensionControls.getControlType().equals(DimensionControlsTypeEnum.OVERALL_CONTROL.getCode())) {
            arrayList1 = this.rulesEnactService.finByByControlsConfigCodeAndDelFlag(dimensionControls.getDelFlag(), dimensionControls.getControlsConfigCode());
        } else if (dimensionControls.getControlType().equals(DimensionControlsTypeEnum.DIMENSION_CONTROL.getCode())) {
            arrayList2 = this.budgetProjectService.finByByControlsConfigCodeAndDelFlag(dimensionControls.getDelFlag(), dimensionControls.getControlsConfigCode());
        }
        DimensionControlsVo dimensionControlsVo = (DimensionControlsVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dimensionControls, DimensionControlsVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return new ControlTypeDataVo(dimensionControlsVo, arrayList1, arrayList2);
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(ControlTypeDataDto dto) {
        DimensionControlsDto dimensionControlsDto = dto.getDimensionControlsDto();
        List rulesEnactDto = dto.getRulesEnactDto();
        List budgetProjectDto = dto.getBudgetProjectDto();
        DimensionControls byId = this.dimensionControlsRepository.getConfigCode(dimensionControlsDto.getControlsConfigCode());
        if (ObjectUtils.isEmpty((Object)((Object)byId))) {
            throw new RuntimeException("\u4fee\u6539\u6570\u636e\u5931\u8d25\uff0c\u539f\u6570\u636e\u4e0d\u5b58\u5728\uff01");
        }
        if (!byId.getControlsConfigCode().equals(dimensionControlsDto.getControlsConfigCode())) {
            throw new RuntimeException("\u7ba1\u63a7\u914d\u7f6e\u7f16\u7801\u4e0d\u53ef\u88ab\u4fee\u6539");
        }
        if (dto.getDimensionControlsDto().getControlsConfigName().length() > 64) {
            throw new RuntimeException("\u7ba1\u63a7\u914d\u7f6e\u540d\u79f0\u8fc7\u957f\uff0c\u4e0d\u80fd\u8d85\u8fc764");
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getDimensionControlsDto().getRemark()) && (long)dto.getDimensionControlsDto().getRemark().length() > 400L) {
            throw new RuntimeException("\u89c4\u5219\u63cf\u8ff0\u8fc7\u957f\uff0c\u4e0d\u80fd\u8d85\u8fc7400");
        }
        if (dimensionControlsDto.getModifyTime() != null) {
            dimensionControlsDto.setModifyTime(new Date());
        }
        if (BooleanEnum.FALSE.getCapital().equals(dimensionControlsDto.getIfRolling())) {
            dimensionControlsDto.setRollingType(null);
        }
        DimensionControls dimensionControls = (DimensionControls)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dimensionControlsDto, DimensionControls.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        this.dimensionControlsRepository.deleteById(dimensionControls);
        dimensionControls.setTenantCode(TenantUtils.getTenantCode());
        this.dimensionControlsRepository.saveOrUpdate((Object)dimensionControls);
        if (dimensionControlsDto.getControlType().equals(DimensionControlsTypeEnum.OVERALL_CONTROL.getCode())) {
            this.rulesEnactService.deleteByControlsConfigCode(dimensionControlsDto.getControlsConfigCode());
            this.rulesEnactService.savaBatch(rulesEnactDto);
        }
        if (dimensionControlsDto.getControlType().equals(DimensionControlsTypeEnum.DIMENSION_CONTROL.getCode())) {
            this.budgetProjectService.checkRepeat(budgetProjectDto, dimensionControlsDto);
            this.budgetProjectService.deleteByControlsConfigCode(dimensionControlsDto.getControlsConfigCode());
            this.budgetProjectService.savaBatch(budgetProjectDto);
        }
        DimensionControlsLogEventDto logEventDto = new DimensionControlsLogEventDto();
        DimensionControlsVo dimensionControlsVo = (DimensionControlsVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)byId, DimensionControlsVo.class, HashSet.class, ArrayList.class, new String[0]);
        logEventDto.setOriginal(dimensionControlsVo);
        logEventDto.setNewest(dimensionControlsDto);
        SerializableBiConsumer & Serializable onUpdate = DimensionControlsLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, DimensionControlsLogEventListener.class, (SerializableBiConsumer)onUpdate);
    }

    private List<DimensionControlsVo> findByIds(Set<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List approvalCollects = this.dimensionControlsRepository.listByIds(ids);
        if (CollectionUtils.isEmpty((Collection)approvalCollects)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)approvalCollects, DimensionControls.class, DimensionControlsVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    public DimensionControlsDto findBudgetManagement(BasicInformationQueryBudgetItemsDto dto) {
        return this.dimensionControlsRepository.findBudgetManagement(dto);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(Set<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\uff01");
        }
        List dimensionControls = this.dimensionControlsRepository.listByIds(ids);
        if (!CollectionUtils.isEmpty((Collection)dimensionControls)) {
            dimensionControls.forEach(dimensionBudgetVo -> {
                dimensionBudgetVo.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
                DimensionControlsLogEventDto logEventDto = new DimensionControlsLogEventDto();
                DimensionControlsVo oldVo = (DimensionControlsVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dimensionControls, DimensionControlsVo.class, null, null, new String[0]);
                logEventDto.setOriginal(oldVo);
                DimensionControlsDto dimensionControlsDto = (DimensionControlsDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)dimensionControls, DimensionControlsDto.class, null, null, new String[0]);
                dimensionControlsDto.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
                logEventDto.setNewest(dimensionControlsDto);
                SerializableBiConsumer & Serializable onDelete = DimensionControlsLogEventListener::onDelete;
                this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, DimensionControlsLogEventListener.class, (SerializableBiConsumer)onDelete);
            });
            this.dimensionControlsRepository.updateBatchById(dimensionControls);
            ids.forEach(controlsById -> this.dimensionControlsRepository.deleteByYearBudgetId((String)controlsById));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e", (Object[])new Object[0]);
        List dimensionControls = this.dimensionControlsRepository.listByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)dimensionControls) ? 1 : 0) != 0, (String)"\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664!", (Object[])new Object[0]);
        ArrayList dimensionControlsList = new ArrayList();
        dimensionControls.forEach(item -> {
            DimensionControls dimensionControls1 = new DimensionControls();
            dimensionControls1.setId(item.getId());
            dimensionControls1.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            dimensionControlsList.add(dimensionControls1);
            DimensionControlsLogEventDto logEventDto = new DimensionControlsLogEventDto();
            DimensionControlsVo oldVo = (DimensionControlsVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, DimensionControlsVo.class, null, null, new String[0]);
            logEventDto.setOriginal(oldVo);
            DimensionControlsDto newDto = (DimensionControlsDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, DimensionControlsDto.class, null, null, new String[0]);
            newDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            logEventDto.setNewest(newDto);
            SerializableBiConsumer & Serializable onEnable = DimensionControlsLogEventListener::onEnable;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, DimensionControlsLogEventListener.class, (SerializableBiConsumer)onEnable);
        });
        this.dimensionControlsRepository.updateBatchById(dimensionControlsList);
    }

    public void disableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e", (Object[])new Object[0]);
        List dimensionControls = this.dimensionControlsRepository.listByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)dimensionControls) ? 1 : 0) != 0, (String)"\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664!", (Object[])new Object[0]);
        ArrayList dimensionControlsList = new ArrayList();
        dimensionControls.forEach(item -> {
            DimensionControls dimensionControls1 = new DimensionControls();
            dimensionControls1.setId(item.getId());
            dimensionControls1.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            dimensionControlsList.add(dimensionControls1);
            DimensionControlsLogEventDto logEventDto = new DimensionControlsLogEventDto();
            DimensionControlsVo oldVo = (DimensionControlsVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, DimensionControlsVo.class, null, null, new String[0]);
            logEventDto.setOriginal(oldVo);
            DimensionControlsDto newDto = (DimensionControlsDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, DimensionControlsDto.class, null, null, new String[0]);
            newDto.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            logEventDto.setNewest(newDto);
            SerializableBiConsumer & Serializable onDisable = DimensionControlsLogEventListener::onDisable;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, DimensionControlsLogEventListener.class, (SerializableBiConsumer)onDisable);
        });
        this.dimensionControlsRepository.updateBatchById(dimensionControlsList);
    }

    public List<DimensionControlsVo> listByConditions(DimensionControlsDto dimensionControlsDto) {
        Validate.notNull((Object)dimensionControlsDto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<DimensionControls> dimensionControlsList = this.dimensionControlsRepository.listByConditions(dimensionControlsDto);
        if (CollectionUtils.isEmpty(dimensionControlsList)) {
            return null;
        }
        List dimensionControlsVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(dimensionControlsList, DimensionControls.class, DimensionControlsVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        List controlsConfigCodeList = dimensionControlsVos.stream().map(DimensionControlsVo::getControlsConfigCode).collect(Collectors.toList());
        List budgetProjectVos = this.budgetProjectService.listByControlsConfigCodeList(controlsConfigCodeList);
        if (CollectionUtils.isEmpty((Collection)budgetProjectVos)) {
            return dimensionControlsVos;
        }
        Map<String, List<BudgetProjectVo>> map = budgetProjectVos.stream().collect(Collectors.groupingBy(BudgetProjectVo::getControlsConfigCode));
        dimensionControlsVos.forEach(dimensionControlsVo -> {
            if (map.containsKey(dimensionControlsVo.getControlsConfigCode())) {
                List collect = ((List)map.get(dimensionControlsVo.getControlsConfigCode())).stream().map(BudgetProjectVo::getBudgetItemCode).collect(Collectors.toList());
                dimensionControlsVo.setBudgetItemCodeList(collect);
            }
        });
        return dimensionControlsVos;
    }

    public List<DimensionControlsVo> findByDimensionControlsDto(DimensionControlsDto dto) {
        return this.dimensionControlsRepository.findByDimensionControlsDto(dto);
    }
}

