/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.controls.config.local.service.internal;

import com.biz.crm.tpm.business.budget.controls.config.local.entity.RulesEnact;
import com.biz.crm.tpm.business.budget.controls.config.local.repository.RulesEnactRepository;
import com.biz.crm.tpm.business.budget.controls.config.local.util.ListConverterUtils;
import com.biz.crm.tpm.business.budget.controls.config.sdk.dto.RulesEnactDto;
import com.biz.crm.tpm.business.budget.controls.config.sdk.service.RulesEnactService;
import com.biz.crm.tpm.business.budget.controls.config.sdk.vo.RulesEnactVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="rulesEnactService")
public class RulesEnactServiceImpl
implements RulesEnactService {
    private static final Logger log = LoggerFactory.getLogger(RulesEnactServiceImpl.class);
    @Autowired
    private RulesEnactRepository rulesEnactRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public void create(RulesEnactDto rulesEnactDto, String promotionCode) {
        rulesEnactDto.setControlsConfigCode(promotionCode);
        RulesEnact rulesEnact = (RulesEnact)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)rulesEnactDto, RulesEnact.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        this.rulesEnactRepository.saveOrUpdate((Object)rulesEnact);
    }

    public RulesEnactVo update(RulesEnactDto dto) {
        List<RulesEnact> formeResult = this.rulesEnactRepository.getcontrolsConfigCode(dto.getControlsConfigCode());
        if (ObjectUtils.isEmpty(formeResult)) {
            throw new RuntimeException("\u4fee\u6539\u6570\u636e\u5931\u8d25\uff0c\u539f\u6570\u636e\u4e0d\u5b58\u5728\uff01");
        }
        RulesEnact value = (RulesEnact)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, RulesEnact.class, HashSet.class, ArrayList.class, new String[0]));
        this.rulesEnactRepository.saveOrUpdate((Object)value);
        RulesEnactVo rulesEnactVo = (RulesEnactVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, RulesEnactVo.class, HashSet.class, ArrayList.class, new String[0]);
        return rulesEnactVo;
    }

    public void deleteByControlsConfigCode(String controlsConfigCode) {
        this.rulesEnactRepository.deleteByControlsConfigCode(controlsConfigCode);
    }

    public void savaBatch(List<RulesEnactDto> dto) {
        for (RulesEnactDto d : dto) {
            d.setId(null);
        }
        if (dto != null && dto.size() > 0) {
            ArrayList productEntityList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(dto, RulesEnactDto.class, RulesEnact.class, HashSet.class, ArrayList.class, new String[0]));
            this.rulesEnactRepository.saveOrUpdateBatch(productEntityList);
        }
    }

    public List<RulesEnactVo> finByByControlsConfigCodeAndDelFlag(String delFlag, String controlsConfigCode) {
        List<RulesEnact> result = this.rulesEnactRepository.finByByControlsConfigCodeAndDelFlag(delFlag, controlsConfigCode);
        ListConverterUtils<RulesEnact, RulesEnactVo> converterUtils = new ListConverterUtils<RulesEnact, RulesEnactVo>(RulesEnactVo.class);
        List<RulesEnactVo> arrayList = converterUtils.converterList(result);
        return arrayList;
    }

    public List<RulesEnactVo> findByControlsConfigCodes(List<String> controlsConfigCodes) {
        if (CollectionUtils.isEmpty(controlsConfigCodes)) {
            return Lists.newArrayList();
        }
        return this.rulesEnactRepository.findByControlsConfigCodes(controlsConfigCodes);
    }
}

