package com.biz.crm.tpm.business.business.policy.local.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.business.policy.local.entity.BusinessPolicyBudget;
import com.biz.crm.tpm.business.business.policy.local.service.BusinessPolicyBudgetService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 商务政策预算信息(BusinessPolicyBudget)表相关的http接口
 *
 * @author makejava
 * @since 2022-11-05 11:29:46
 */
@RestController
@RequestMapping("/v1/businessPolicyBudget")
@Slf4j
@Api(tags = "商务政策预算信息")
public class BusinessPolicyBudgetController {
  /**
  * 服务对象
  */
  @Autowired
  private BusinessPolicyBudgetService businessPolicyBudgetService;
  
  /**
   * 分页查询所有数据
   *
   * @param pageable 分页对象
   * @param businessPolicyBudget 查询实体
   * @return 所有数据
  */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<BusinessPolicyBudget>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
												   @ApiParam(name = "businessPolicyBudget", value = "商务政策预算信息") BusinessPolicyBudget businessPolicyBudget) {
    try {
      Page<BusinessPolicyBudget> page =  this.businessPolicyBudgetService.findByConditions(pageable,businessPolicyBudget);
      return Result.ok(page);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
  */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<BusinessPolicyBudget> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      BusinessPolicyBudget businessPolicyBudget = this.businessPolicyBudgetService.findById(id);
      return Result.ok(businessPolicyBudget);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 新增数据
   *
   * @param businessPolicyBudget 实体对象
   * @return 新增结果
  */
  @ApiOperation(value = "新增数据")
  @PostMapping
  public Result<BusinessPolicyBudget> create(@ApiParam(name = "businessPolicyBudget", value = "商务政策预算信息") @RequestBody BusinessPolicyBudget businessPolicyBudget) {
    try {
      BusinessPolicyBudget result = this.businessPolicyBudgetService.create(businessPolicyBudget);
      return Result.ok(result);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 修改数据
   *
   * @param businessPolicyBudget 实体对象
   * @return 修改结果
  */
  @ApiOperation(value = "修改数据")
  @PatchMapping
  public Result<BusinessPolicyBudget> update(@ApiParam(name = "businessPolicyBudget", value = "商务政策预算信息") @RequestBody BusinessPolicyBudget businessPolicyBudget) {
    try {
      BusinessPolicyBudget result = this.businessPolicyBudgetService.update(businessPolicyBudget);
      return Result.ok(result);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  @DeleteMapping
  public Result<?> delete(@ApiParam(name = "idList", value = "主键集合") @RequestParam("idList") List<String> idList) {
    try {
      this.businessPolicyBudgetService.delete(idList);
      return Result.ok();
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
