package com.biz.crm.tpm.business.business.policy.local.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.business.policy.local.imports.PolicyProductImportsProcess;
import com.biz.crm.tpm.business.business.policy.local.imports.vo.PolicyProductImportVo;
import com.biz.crm.tpm.business.business.policy.sdk.dto.BusinessPolicyApprovalDto;
import com.biz.crm.tpm.business.business.policy.sdk.dto.BusinessPolicyDto;
import com.biz.crm.tpm.business.business.policy.sdk.service.BusinessPolicyService;
import com.biz.crm.tpm.business.business.policy.sdk.vo.BusinessPolicyVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.*;

/**
 * 商务政策主表(BusinessPolicy)表相关的http接口
 *
 * @author makejava
 * @since 2022-11-05 11:29:45
 */
@RestController
@RequestMapping("/v1/businessPolicy")
@Slf4j
@Api(tags = "商务政策主表")
public class BusinessPolicyController {
    /**
     * 服务对象
     */
    @Autowired(required = false)
    private BusinessPolicyService businessPolicyService;

    @Autowired(required = false)
    private PolicyProductImportsProcess policyProductImportsProcess;

    /**
     * 分页查询所有数据
     *
     * @param pageable       分页对象
     * @param businessPolicy 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findByConditions")
    public Result<Page<BusinessPolicyVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                           @ApiParam(name = "businessPolicy", value = "商务政策主表") BusinessPolicyDto businessPolicy) {
        try {
            Page<BusinessPolicyVo> page = this.businessPolicyService.findByConditions(pageable, businessPolicy);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @ApiOperation(value = "通过主键查询单条数据")
    @GetMapping("{id}")
    public Result<BusinessPolicyVo> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
        try {
            BusinessPolicyVo businessPolicy = this.businessPolicyService.findById(id);
            return Result.ok(businessPolicy);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 新增数据
     *
     * @param businessPolicy 实体对象
     * @return 新增结果
     */
    @ApiOperation(value = "新增数据")
    @PostMapping
    public Result<?> create(@ApiParam(name = "businessPolicy", value = "商务政策主表") @RequestBody BusinessPolicyDto businessPolicy) {
        try {
            this.businessPolicyService.create(businessPolicy);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 修改数据
     *
     * @param businessPolicy 实体对象
     * @return 修改结果
     */
    @ApiOperation(value = "修改数据")
    @PatchMapping
    public Result<?> update(@ApiParam(name = "businessPolicy", value = "商务政策主表") @RequestBody BusinessPolicyDto businessPolicy) {
        try {
            this.businessPolicyService.update(businessPolicy);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 删除数据
     *
     * @param ids 主键结合
     * @return 删除结果
     */
    @DeleteMapping("delete")
    public Result<?> delete(@ApiParam(name = "idList", value = "主键集合") @RequestParam(value = "ids") List<String> ids) {
        try {
            this.businessPolicyService.delete(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @PostMapping("close")
    public Result<?> close(@RequestBody List<String> idList) {
        try {
            this.businessPolicyService.close(idList);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @PostMapping("batchSubmitApproval")
    public Result<?> batchSubmitApproval(@RequestBody BusinessPolicyApprovalDto dto) {
        try {
            this.businessPolicyService.batchSubmitApproval(dto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 编码查询
     *
     * @param businessPolicyCodes
     * @return
     */
    @PostMapping("findActivityFormByCode")
    public Result<List<BusinessPolicyVo>> findBusinessPolicyByCode(@RequestBody Set<String> businessPolicyCodes) {
        try {
            return Result.ok(businessPolicyService.findBusinessPolicyByCode(businessPolicyCodes));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 申请金额修改
     *
     * @param voList
     * @return
     */
    @PostMapping("updateBusinessPolicyApplyAmount")
    public Result<?> updateBusinessPolicyApplyAmount(@RequestBody List<BusinessPolicyVo> voList) {
        try {
            this.businessPolicyService.updateBusinessPolicyApplyAmount(voList);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @GetMapping("testImport")
    public Result<?> testImport(){
        LinkedHashMap<Integer, PolicyProductImportVo> data = new LinkedHashMap<>();
        PolicyProductImportVo policyProductImportVo = new PolicyProductImportVo();
        policyProductImportVo.setProductCode("130100001564");
        policyProductImportVo.setProductName("aaa");
        data.put(1,policyProductImportVo);

        PolicyProductImportVo policyProductImportVo2 = new PolicyProductImportVo();
        policyProductImportVo2.setProductCode("130100002240");
        policyProductImportVo2.setProductName("aaa");
        data.put(2,policyProductImportVo2);

        PolicyProductImportVo policyProductImportVo3 = new PolicyProductImportVo();
        policyProductImportVo3.setProductCode("130100002673");
        policyProductImportVo3.setProductName("aaa");
        data.put(3,policyProductImportVo3);

        PolicyProductImportVo policyProductImportVo4 = new PolicyProductImportVo();
        policyProductImportVo4.setProductCode("130100001828");
        policyProductImportVo4.setProductName("aaa");
        data.put(4,policyProductImportVo4);

        Map<String, Object> params = new HashMap<>();
        params.put("cacheKey","AAAAAAAAAAAAAAAA");
        policyProductImportsProcess.execute(data,null,params);
        return Result.ok();
    }
}
