package com.biz.crm.tpm.business.business.policy.local.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.page.cache.controller.MnPageCacheController;
import com.biz.crm.tpm.business.business.policy.local.entity.BusinessPolicyProduct;
import com.biz.crm.tpm.business.business.policy.local.exports.PolicyProductExportsProcess;
import com.biz.crm.tpm.business.business.policy.local.service.BusinessPolicyProductService;
import com.biz.crm.tpm.business.business.policy.sdk.dto.BusinessPolicyProductDto;
import com.biz.crm.tpm.business.business.policy.sdk.vo.BusinessPolicyProductVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 商务政策考核产品(BusinessPolicyProduct)表相关的http接口
 *
 * @author makejava
 * @since 2022-11-05 11:29:45
 */
@RestController
@RequestMapping("/v1/businessPolicyProduct")
@Slf4j
@Api(tags = "商务政策考核产品")
public class BusinessPolicyProductController extends MnPageCacheController<BusinessPolicyProductVo, BusinessPolicyProductDto> {
  /**
  * 服务对象
  */
  @Autowired
  private BusinessPolicyProductService businessPolicyProductService;

  @Autowired(required = false)
  private PolicyProductExportsProcess policyProductExportsProcess;
  
  /**
   * 分页查询所有数据
   *
   * @param pageable 分页对象
   * @param businessPolicyProduct 查询实体
   * @return 所有数据
  */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<BusinessPolicyProduct>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
												   @ApiParam(name = "businessPolicyProduct", value = "商务政策考核产品") BusinessPolicyProduct businessPolicyProduct) {
    try {
      Page<BusinessPolicyProduct> page =  this.businessPolicyProductService.findByConditions(pageable,businessPolicyProduct);
      return Result.ok(page);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
  */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<BusinessPolicyProduct> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      BusinessPolicyProduct businessPolicyProduct = this.businessPolicyProductService.findById(id);
      return Result.ok(businessPolicyProduct);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 新增数据
   *
   * @param businessPolicyProduct 实体对象
   * @return 新增结果
  */
  @ApiOperation(value = "新增数据")
  @PostMapping
  public Result<BusinessPolicyProduct> create(@ApiParam(name = "businessPolicyProduct", value = "商务政策考核产品") @RequestBody BusinessPolicyProduct businessPolicyProduct) {
    try {
      BusinessPolicyProduct result = this.businessPolicyProductService.create(businessPolicyProduct);
      return Result.ok(result);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 修改数据
   *
   * @param businessPolicyProduct 实体对象
   * @return 修改结果
  */
  @ApiOperation(value = "修改数据")
  @PatchMapping
  public Result<BusinessPolicyProduct> update(@ApiParam(name = "businessPolicyProduct", value = "商务政策考核产品") @RequestBody BusinessPolicyProduct businessPolicyProduct) {
    try {
      BusinessPolicyProduct result = this.businessPolicyProductService.update(businessPolicyProduct);
      return Result.ok(result);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  @DeleteMapping
  public Result<?> delete(@ApiParam(name = "idList", value = "主键集合") @RequestParam("idList") List<String> idList) {
    try {
      this.businessPolicyProductService.delete(idList);
      return Result.ok();
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
