package com.biz.crm.tpm.business.business.policy.local.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.business.policy.local.entity.BusinessPolicyScope;
import com.biz.crm.tpm.business.business.policy.local.exports.BusinessPolicyScopeExportProcess;
import com.biz.crm.tpm.business.business.policy.local.imports.BusinessPolicyScopeImportProcess;
import com.biz.crm.tpm.business.business.policy.local.service.BusinessPolicyScopeService;
import com.biz.crm.tpm.business.business.policy.sdk.dto.BusinessPolicyScopeDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 政策范围(BusinessPolicyScope)表相关的http接口
 *
 * @author makejava
 * @since 2022-11-05 11:29:41
 */
@RestController
@RequestMapping("/v1/businessPolicyScope")
@Slf4j
@Api(tags = "政策范围")
public class BusinessPolicyScopeController {
  /**
  * 服务对象
  */
  @Autowired
  private BusinessPolicyScopeService businessPolicyScopeService;

  @Autowired(required = false)
  private BusinessPolicyScopeExportProcess businessPolicyScopeExportProcess;

  @Autowired(required = false)
  private BusinessPolicyScopeImportProcess businessPolicyScopeImportProcess;
  
  /**
   * 分页查询所有数据
   *
   * @param pageable 分页对象
   * @param businessPolicyScope 查询实体
   * @return 所有数据
  */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<BusinessPolicyScope>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
												   @ApiParam(name = "businessPolicyScope", value = "政策范围") BusinessPolicyScope businessPolicyScope) {
    try {
      Page<BusinessPolicyScope> page =  this.businessPolicyScopeService.findByConditions(pageable,businessPolicyScope);
      return Result.ok(page);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
  */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<BusinessPolicyScope> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      BusinessPolicyScope businessPolicyScope = this.businessPolicyScopeService.findById(id);
      return Result.ok(businessPolicyScope);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 新增数据
   *
   * @param businessPolicyScope 实体对象
   * @return 新增结果
  */
  @ApiOperation(value = "新增数据")
  @PostMapping
  public Result<BusinessPolicyScope> create(@ApiParam(name = "businessPolicyScope", value = "政策范围") @RequestBody BusinessPolicyScope businessPolicyScope) {
    try {
      BusinessPolicyScope result = this.businessPolicyScopeService.create(businessPolicyScope);
      return Result.ok(result);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 修改数据
   *
   * @param businessPolicyScope 实体对象
   * @return 修改结果
  */
  @ApiOperation(value = "修改数据")
  @PatchMapping
  public Result<BusinessPolicyScope> update(@ApiParam(name = "businessPolicyScope", value = "政策范围") @RequestBody BusinessPolicyScope businessPolicyScope) {
    try {
      BusinessPolicyScope result = this.businessPolicyScopeService.update(businessPolicyScope);
      return Result.ok(result);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  @DeleteMapping
  public Result<?> delete(@ApiParam(name = "idList", value = "主键集合") @RequestParam("idList") List<String> idList) {
    try {
      this.businessPolicyScopeService.delete(idList);
      return Result.ok();
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @PostMapping("saveScopeExports")
  public Result<?> saveScopeExports(@RequestBody List<BusinessPolicyScopeDto> dtos){
    try {
      return Result.ok(this.businessPolicyScopeExportProcess.saveScopeExports(dtos));
    }catch (Exception e){
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @GetMapping("getPolicyScope")
  public Result<List<BusinessPolicyScopeDto>> getPolicyScope(@RequestParam("cacheKey")String cacheKey){
    try {
      return Result.ok(businessPolicyScopeImportProcess.getPolicyScope(cacheKey));
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
