package com.biz.crm.tpm.business.business.policy.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/5 10:19
 * @description：商务政策主表
 */
@ApiModel(value = "BusinessPolicy", description = "商务政策主表")
@TableName("tpm_business_policy")
@Getter
@Setter
@Entity(name = "tpm_business_policy")
@org.hibernate.annotations.Table(appliesTo = "tpm_business_policy", comment = "商务政策主表")
@Table(name = "tpm_business_policy")
public class BusinessPolicy extends TenantFlagOpEntity {

    @ApiModelProperty(name = "商务政策编码", notes = "商务政策编码")
    @Column(name = "business_policy_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '商务政策编码'")
    private String businessPolicyCode;

    @ApiModelProperty(name = "商务政策名称", notes = "商务政策名称")
    @Column(name = "business_policy_name",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '商务政策名称'")
    private String businessPolicyName;

    @ApiModelProperty(name = "政策开始时间", notes = "政策开始时间")
    @Column(name = "policy_begin_time",  length = 128, columnDefinition = "datetime COMMENT '政策开始时间'")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date policyBeginTime;

    @ApiModelProperty(name = "政策结束时间", notes = "政策结束时间")
    @Column(name = "policy_end_time",  length = 128, columnDefinition = "datetime COMMENT '政策结束时间'")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date policyEndTime;

    @ApiModelProperty(name = "审批状态", notes = "审批状态")
    @Column(name = "process_status",  length = 10, columnDefinition = "VARCHAR(10) COMMENT '审批状态'")
    private String processStatus;

    @ApiModelProperty(name = "申请金额", notes = "申请金额")
    @Column(name = "apply_amount",  columnDefinition = "decimal(24,6) COMMENT '申请金额'")
    private BigDecimal applyAmount;

    @ApiModelProperty("流程编码")
    @Column(name = "process_no",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '流程编码'")
    private String processNo;

    @ApiModelProperty("已使用金额")
    @Column(name = "already_use_amount", columnDefinition = "decimal(24,6) COMMENT '已使用金额'")
    private BigDecimal alreadyUseAmount;

    @ApiModelProperty("已结案金额")
    @Column(name = "already_audit_amount", columnDefinition = "decimal(24,6) COMMENT '已结案金额'")
    private BigDecimal alreadyAuditAmount;

    @ApiModelProperty("是否完全结案")
    @Column(name = "whole_audit", length = 10, columnDefinition = "VARCHAR(10) COMMENT '是否完全结案'")
    private String wholeAudit;

}
