package com.biz.crm.tpm.business.business.policy.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/5 10:31
 * @description：商务政策预算信息
 */
@ApiModel(value = "BusinessPolicyBudget", description = "商务政策预算信息")
@TableName("tpm_business_policy_budget")
@Getter
@Setter
@Entity(name = "tpm_business_policy_budget")
@org.hibernate.annotations.Table(appliesTo = "tpm_business_policy_budget", comment = "商务政策预算信息")
@Table(name = "tpm_business_policy_budget")
public class BusinessPolicyBudget extends TenantFlagOpEntity {

    @ApiModelProperty(name = "商务政策编码", notes = "商务政策编码")
    @Column(name = "business_policy_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '商务政策编码'")
    private String businessPolicyCode;

    @ApiModelProperty(name = "预算编码", notes = "预算编码")
    @Column(name = "budget_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '预算编码'")
    private String budgetCode;

    @ApiModelProperty(name = "三级预算项目", notes = "三级预算项目")
    @Column(name = "third_budget_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '三级预算项目'")
    private String thirdBudgetCode;

    @ApiModelProperty(name = "三级预算项目可用余额", notes = "三级预算项目可用余额")
    @Column(name = "third_budget_amount", columnDefinition = "decimal(24,6) COMMENT '三级预算项目可用余额'")
    private BigDecimal thirdBudgetAmount;

    @ApiModelProperty(name = "二级预算项目", notes = "二级预算项目")
    @Column(name = "second_budget_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '二级预算项目'")
    private String secondBudgetCode;

    @ApiModelProperty(name = "二级预算项目可用余额", notes = "二级预算项目可用余额")
    @Column(name = "second_budget_amount", columnDefinition = "decimal(24,6) COMMENT '二级预算项目可用余额'")
    private BigDecimal secondBudgetAmount;

    @ApiModelProperty(name = "一级预算项目", notes = "一级预算项目")
    @Column(name = "first_budget_amount",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '一级预算项目'")
    private String firstBudgetAmount;

    @ApiModelProperty(name = "年月", notes = "年月")
    @Column(name = "year_and_month",  length = 10, columnDefinition = "VARCHAR(10) COMMENT '年月'")
    private String yearAndMonth;

    @ApiModelProperty(name = "归口", notes = "归口")
    @Column(name = "fee_belong_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '费用归口[数据字典:tpm_fee_belong] '")
    private String feeBelongCode;

    @ApiModelProperty(name = "组织", notes = "组织")
    @Column(name = "org_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '组织'")
    private String orgCode;

    @ApiModelProperty(name = "组织名称", notes = "组织名称")
    @Column(name = "org_name",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '组织名称'")
    private String orgName;

    @ApiModelProperty(name = "客户", notes = "客户")
    @Column(name = "customer_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户'")
    private String customerCode;

    @ApiModelProperty(name = "客户名称", notes = "客户名称")
    @Column(name = "customer_name",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '客户名称'")
    private String customerName;

    /**
     * 品牌编码
     */
    @ApiModelProperty(value = "品牌编码", notes = "")
    @Column(name = "product_brand_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '品牌编码 '")
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty(value = "品牌名称", notes = "")
    @Column(name = "product_brand_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '品牌名称 '")
    private String productBrandName;

    /**
     * 申请金额
     */
    @ApiModelProperty(value = "申请金额", notes = "")
    @Column(name = "apply_amount", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '申请金额 '")
    private BigDecimal applyAmount;

    /**
     * 预算管控可用余额
     */
    @ApiModelProperty(value = "预算管控可用余额", notes = "")
    @Column(name = "control_balance_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '预算管控可用余额 '")
    private BigDecimal controlBalanceAmount;

    /**
     * 管控率
     */
    @ApiModelProperty(value = "管控率", notes = "")
    @Column(name = "control_ratio", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '管控率'")
    private BigDecimal controlRatio;

    /**
     * 费用率
     */
    @ApiModelProperty(value = "费用率", notes = "")
    @Column(name = "fee_ratio", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '费用率'")
    private BigDecimal feeRatio;

    /**
     * 管控类型
     */
    @ApiModelProperty(value = "管控类型[数据字典:tpm_budget_control_type]", notes = "")
    @Column(name = "control_type_code", length = 64, columnDefinition = "varchar(64) COMMENT '管控类型'")
    private String controlTypeCode;

    /**
     * 预估销售额
     */
    @ApiModelProperty("预估销售额")
    @Column(name = "estimate_sale_amount", columnDefinition = "decimal(20,4) COMMENT '预估销售额'")
    private BigDecimal estimateSaleAmount;
}
