package com.biz.crm.tpm.business.business.policy.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/5 11:13
 * @description：商务政策考核产品
 */
@ApiModel(value = "BusinessPolicyProduct", description = "商务政策考核产品")
@TableName("tpm_business_policy_product")
@Getter
@Setter
@Entity(name = "tpm_business_policy_product")
@org.hibernate.annotations.Table(appliesTo = "tpm_business_policy_product", comment = "商务政策考核产品")
@Table(name = "tpm_business_policy_product")
public class BusinessPolicyProduct extends TenantFlagOpEntity {

    @ApiModelProperty(name = "商务政策编码", notes = "商务政策编码")
    @Column(name = "business_policy_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '商务政策编码'")
    private String businessPolicyCode;

    /**
     * 品牌编码
     */
    @ApiModelProperty(value = "品牌编码", notes = "")
    @Column(name = "product_brand_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '品牌编码 '")
    @Deprecated
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty(value = "品牌名称", notes = "")
    @Column(name = "product_brand_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '品牌名称 '")
    @Deprecated
    private String productBrandName;

    /**
     * 品类编码
     */
    @ApiModelProperty(value = "品类编码", notes = "")
    @Column(name = "product_category_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '品类编码 '")
    @Deprecated
    private String productCategoryCode;

    /**
     * 品类名称
     */
    @ApiModelProperty(value = "品类名称", notes = "")
    @Column(name = "product_category_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '品类名称 '")
    @Deprecated
    private String productCategoryName;

    /**
     * 产品编码
     */
    @ApiModelProperty(name = "产品编码", notes = "产品编码")
    @Column(name = "product_code", nullable = true, length = 128, columnDefinition = "varchar(128) COMMENT '产品编码'")
    private String productCode;
    /**
     * 产品名称
     */
    @ApiModelProperty(name = "产品名称", notes = "产品名称")
    @Column(name = "product_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '产品名称'")
    private String productName;

    @ApiModelProperty("供货价(元)")
    @Column(name = "offer_goods_price", columnDefinition = "DECIMAL(24,6) COMMENT '供货价(元)'")
    private BigDecimal offerGoodsPrice;

    @ApiModelProperty("预计销量(件)")
    @Column(name = "predict_sale_quantity", columnDefinition = "DECIMAL(24,6) COMMENT '预计销量(件)'")
    private BigDecimal predictSaleQuantity;

    @ApiModelProperty("预计折前销售额(元)")
    @Column(name = "predict_before_discount_sale_amount", columnDefinition = "DECIMAL(24,6) COMMENT '预计折前销售额(元)'")
    private BigDecimal predictBeforeDiscountSaleAmount;

    @ApiModelProperty("旬返-点数")
    @Column(name = "ten_day_return_point", columnDefinition = "DECIMAL(24,6) COMMENT '旬返-点数'")
    private BigDecimal tenDayReturnPoint;

    @ApiModelProperty("月返-点数")
    @Column(name = "month_return_point", columnDefinition = "DECIMAL(24,6) COMMENT '月返-点数'")
    private BigDecimal monthReturnPoint;

    @ApiModelProperty("目标达成返点")
    @Column(name = "target_reach_return_point", columnDefinition = "DECIMAL(24,6) COMMENT '目标达成返点'")
    private BigDecimal targetReachReturnPoint;

    @ApiModelProperty("组合装点数")
    @Column(name = "combination_point", columnDefinition = "DECIMAL(24,6) COMMENT '组合装点数'")
    private BigDecimal combinationPoint;

    @ApiModelProperty("基础运营点数")
    @Column(name = "base_operation_point", columnDefinition = "DECIMAL(24,6) COMMENT '基础运营点数'")
    private BigDecimal baseOperationPoint;

    @Column(name = "man_point", columnDefinition = "DECIMAL(24,6) COMMENT '人员点数'")
    @ApiModelProperty("人员点数")
    private BigDecimal manPoint;

    @ApiModelProperty("投放点数")
    @Column(name = "put_point", columnDefinition = "DECIMAL(24,6) COMMENT '投放点数'")
    private BigDecimal putPoint;

    @ApiModelProperty("物流点数")
    @Column(name = "logistic_point", columnDefinition = "DECIMAL(24,6) COMMENT '物流点数'")
    private BigDecimal logisticPoint;

    @ApiModelProperty("季返点数")
    @Column(name = "quarter_return_point", columnDefinition = "DECIMAL(24,6) COMMENT '季返点数'")
    private BigDecimal quarterReturnPoint;

    @ApiModelProperty("年返点数")
    @Column(name = "year_return_point", columnDefinition = "DECIMAL(24,6) COMMENT '年返点数'")
    private BigDecimal yearReturnPoint;

    @ApiModelProperty("其他政策1-点数")
    @Column(name = "other_policy1_point", columnDefinition = "DECIMAL(24,6) COMMENT '其他政策1-点数'")
    private BigDecimal otherPolicy1Point;

    @ApiModelProperty("其他政策2-点数")
    @Column(name = "other_policy2_point", columnDefinition = "DECIMAL(24,6) COMMENT '其他政策2-点数'")
    private BigDecimal otherPolicy2Point;

    @ApiModelProperty("其他政策3-点数")
    @Column(name = "other_policy3_point", columnDefinition = "DECIMAL(24,6) COMMENT '其他政策3-点数'")
    private BigDecimal otherPolicy3Point;

    @ApiModelProperty("其他政策4-价格")
    @Column(name = "other_policy4_price", columnDefinition = "DECIMAL(24,6) COMMENT '其他政策4-价格'")
    private BigDecimal otherPolicy4Price;

    @ApiModelProperty(" 基础返点(旬返) 费用")
    @Column(name = "base_return_point_ten_day_return_fee", columnDefinition = "DECIMAL(24,6) COMMENT '基础返点(旬返) 费用'")
    private BigDecimal baseReturnPointTenDayReturnFee;

    @ApiModelProperty("基础返点(月返) 费用")
    @Column(name = "base_return_point_month_return_fee", columnDefinition = "DECIMAL(24,6) COMMENT '基础返点(月返) 费用'")
    private BigDecimal baseReturnPointMonthReturnFee;

    @ApiModelProperty("目标达成返点费用")
    @Column(name = "target_reach_return_point_fee", columnDefinition = "DECIMAL(24,6) COMMENT '目标达成返点费用'")
    private BigDecimal targetReachReturnPointFee;

    @ApiModelProperty("组合装费用")
    @Column(name = "combination_fee", columnDefinition = "DECIMAL(24,6) COMMENT '组合装费用'")
    private BigDecimal combinationFee;

    @ApiModelProperty("基础运营费用")
    @Column(name = "base_operation_fee", columnDefinition = "DECIMAL(24,6) COMMENT '基础运营费用'")
    private BigDecimal baseOperationFee;

    @ApiModelProperty("人员费用")
    @Column(name = "people_fee", columnDefinition = "DECIMAL(24,6) COMMENT '人员费用'")
    private BigDecimal peopleFee;

    @ApiModelProperty("投放费用")
    @Column(name = "put_fee", columnDefinition = "DECIMAL(24,6) COMMENT '投放费用'")
    private BigDecimal putFee;

    @ApiModelProperty("物流支持费用")
    @Column(name = "logistic_support_fee", columnDefinition = "DECIMAL(24,6) COMMENT '物流支持费用'")
    private BigDecimal logisticSupportFee;

    @ApiModelProperty("季返费用")
    @Column(name = "quarter_return_fee", columnDefinition = "DECIMAL(24,6) COMMENT '季返费用'")
    private BigDecimal quarterReturnFee;

    @ApiModelProperty("年返费用")
    @Column(name = "year_return_fee", columnDefinition = "DECIMAL(24,6) COMMENT '年返费用'")
    private BigDecimal yearReturnFee;

    @ApiModelProperty("其他政策1-费用")
    @Column(name = "other_policy1_fee", columnDefinition = "DECIMAL(24,6) COMMENT '其他政策1-费用'")
    private BigDecimal otherPolicy1Fee;

    @ApiModelProperty("其他政策2-费用")
    @Column(name = "other_policy2_fee", columnDefinition = "DECIMAL(24,6) COMMENT '其他政策2-费用'")
    private BigDecimal otherPolicy2Fee;

    @ApiModelProperty("其他政策3-费用")
    @Column(name = "other_policy3_fee", columnDefinition = "DECIMAL(24,6) COMMENT '其他政策3-费用'")
    private BigDecimal otherPolicy3Fee;

    @ApiModelProperty("其他政策4-费用")
    @Column(name = "other_policy4_fee", columnDefinition = "DECIMAL(24,6) COMMENT '其他政策4-费用'")
    private BigDecimal otherPolicy4Fee;

    @ApiModelProperty("费用小计")
    @Column(name = "fee_total", columnDefinition = "DECIMAL(24,6) COMMENT '费用小计'")
    private BigDecimal feeTotal;
}
