package com.biz.crm.tpm.business.business.policy.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/5 11:18
 * @description：政策范围
 */
@ApiModel(value = "BusinessPolicyScope", description = "政策范围")
@TableName("tpm_business_policy_scope")
@Getter
@Setter
@Entity(name = "tpm_business_policy_scope")
@org.hibernate.annotations.Table(appliesTo = "tpm_business_policy_scope", comment = "政策范围")
@Table(name = "tpm_business_policy_scope")
public class BusinessPolicyScope extends TenantFlagOpEntity {

    @ApiModelProperty(name = "商务政策编码", notes = "商务政策编码")
    @Column(name = "business_policy_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '商务政策编码'")
    private String businessPolicyCode;

    @ApiModelProperty(name = "类型（1-客户，2-客户等级）", notes = "类型（1-客户，2-客户等级）")
    @Column(name = "type",  length = 10, columnDefinition = "VARCHAR(10) COMMENT '类型（1-客户，2-客户等级）'")
    @Deprecated
    private String type;

    @ApiModelProperty(name = "客户等级", notes = "客户等级")
    @Column(name = "customer_grade",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户等级'")
    private String customerGrade;

    @ApiModelProperty(name = "客户编码", notes = "客户编码")
    @Column(name = "customer_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户编码'")
    @Deprecated
    private String customerCode;

    @ApiModelProperty(name = "客户名称", notes = "客户名称")
    @Column(name = "customer_name",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '客户名称'")
    @Deprecated
    private String customerName;

    @ApiModelProperty("客户合同量")
    @Column(name = "customer_contract_quantity", columnDefinition = "VARCHAR(32) COMMENT '客户合同量'")
    private String customerContractQuantity;

    @ApiModelProperty("基础返点(旬返)")
    @Column(name = "base_ten_day_return_point", columnDefinition = "decimal(24,6) COMMENT '基础返点(旬返)'")
    private BigDecimal baseTenDayReturnPoint;

    @ApiModelProperty("基础返点(月返)")
    @Column(name = "base_month_return_point", columnDefinition = "decimal(24,6) COMMENT '基础返点(月返)'")
    private BigDecimal baseMonthReturnPoint;

    @ApiModelProperty("目标达成返点")
    @Column(name = "target_conclude_return_point", columnDefinition = "decimal(24,6) COMMENT '目标达成返点'")
    private BigDecimal targetConcludeReturnPoint;

    @ApiModelProperty("组合装点数")
    @Column(name = "combination_point", columnDefinition = "decimal(24,6) COMMENT '组合装点数'")
    private BigDecimal combinationPoint;

    @ApiModelProperty("其他政策1-点数")
    @Column(name = "other_policy1_point", columnDefinition = "decimal(24,6) COMMENT '其他政策1-点数'")
    private BigDecimal otherPolicy1Point;

    @ApiModelProperty("其他政策2-点数")
    @Column(name = "other_policy2_point", columnDefinition = "decimal(24,6) COMMENT '其他政策2-点数'")
    private BigDecimal otherPolicy2Point;

    @ApiModelProperty("其他政策3-点数")
    @Column(name = "other_policy3_point", columnDefinition = "decimal(24,6) COMMENT '其他政策3-点数'")
    private BigDecimal otherPolicy3Point;

    @ApiModelProperty("其他政策4-价格")
    @Column(name = "other_policy4_price", columnDefinition = "decimal(24,6) COMMENT '其他政策4-价格'")
    private BigDecimal otherPolicy4Price;

    @ApiModelProperty("基础运营")
    @Column(name = "base_operation", columnDefinition = "decimal(24,6) COMMENT '基础运营'")
    private BigDecimal baseOperation;

    @ApiModelProperty("人员费用")
    @Column(name = "people_fee", columnDefinition = "decimal(24,6) COMMENT '人员费用'")
    private BigDecimal peopleFee;

    @ApiModelProperty("投放费用")
    @Column(name = "put_fee", columnDefinition = "decimal(24,6) COMMENT '投放费用'")
    private BigDecimal putFee;

    @ApiModelProperty("物流费用")
    @Column(name = "logistics_fee", columnDefinition = "decimal(24,6) COMMENT '物流费用'")
    private BigDecimal logisticsFee;

    @ApiModelProperty("季度返")
    @Column(name = "quarter_return", columnDefinition = "decimal(24,6) COMMENT '季度返'")
    private BigDecimal quarterReturn;

    @ApiModelProperty("年返兑现")
    @Column(name = "year_return_cash", columnDefinition = "decimal(24,6) COMMENT '年返兑现'")
    private BigDecimal yearReturnCash;
}
