package com.biz.crm.tpm.business.business.policy.local.exports;

import com.alibaba.fastjson.JSONArray;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import com.biz.crm.tpm.business.business.policy.local.constants.BusinessPolicyConstants;
import com.biz.crm.tpm.business.business.policy.local.exports.vo.BusinessPolicyScopeExportVo;
import com.biz.crm.tpm.business.business.policy.sdk.dto.BusinessPolicyScopeDto;
import com.bizunited.nebula.common.util.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @Author : dengwei
 * @Date :2023/7/3  15:53
 * @Description: 促销政策范围导出
 */
@Component
public class BusinessPolicyScopeExportProcess implements ExportProcess<BusinessPolicyScopeExportVo> {

    @Autowired(required = false)
    private RedisService redisService;


    @Override
    public Integer getPageSize(){
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }


    @Override
    public Integer getTotal(Map<String, Object> params) {
        String cacheKey = getFromCacheKey(params);
        Object o = redisService.get(cacheKey);
        if(Objects.isNull(o)){
            return 0;
        }
        List<BusinessPolicyScopeExportVo> list = JsonUtils.json2Obj((String) o, new TypeReference<List<BusinessPolicyScopeExportVo>>() {
        });
        if(CollectionUtils.isEmpty(list)){
            return 0;
        }
        Integer total = list.size();
        Validate.isTrue(total < CommonConstant.IE_EXPORT_MAX_TOTAL, "导出时，" +
                "单次最大导出[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]条,请输入更多查询条件!!");
        return total;
    }

    private String getFromCacheKey(Map<String, Object> params) {
        String cacheKey = (String)params.get("cacheKey");
        Validate.isTrue(!StringUtils.isEmpty(cacheKey),"缓存key不能空");
        return BusinessPolicyConstants.BUSINESS_POLICY_SCOPE_PRE + cacheKey;
    }

    @Override
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        String cacheKey = getFromCacheKey(params);
        Object o = redisService.get(cacheKey);
        if(Objects.isNull(o)){
            return new JSONArray();
        }
        return JSONArray.parseArray((String) o);
    }

    public String saveScopeExports(List<BusinessPolicyScopeDto> dtos) {
        Validate.isTrue(!CollectionUtils.isEmpty(dtos),"保存的数据不能为空");

        String cacheKey = UuidCrmUtil.randomUuid();
        redisService.set(BusinessPolicyConstants.BUSINESS_POLICY_SCOPE_PRE + cacheKey,JsonUtils.obj2JsonString(dtos),300);
        return cacheKey;
    }

    @Override
    public String getBusinessCode() {
        return "business_policy_scope_export_process";
    }

    @Override
    public String getBusinessName() {
        return "促销政策范围导出";
    }
}
