package com.biz.crm.tpm.business.business.policy.local.exports;

import com.alibaba.fastjson.JSONArray;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.business.policy.local.exports.vo.PolicyProductExportVo;
import com.biz.crm.tpm.business.business.policy.local.service.BusinessPolicyProductService;
import com.biz.crm.tpm.business.business.policy.sdk.dto.BusinessPolicyProductDto;
import com.bizunited.nebula.common.util.JsonUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;

/**
 * @Author : dengwei
 * @Date :2023/7/3  13:52
 * @Description: 促销政策产品导出
 */
@Component
public class PolicyProductExportsProcess implements ExportProcess<PolicyProductExportVo> {

    @Autowired(required = false)
    private BusinessPolicyProductService businessPolicyProductService;


    @Override
    public Integer getPageSize(){
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }


    @Override
    public Integer getTotal(Map<String, Object> params) {
        String cacheKey = getFromCacheKey(params);

        List<BusinessPolicyProductDto> cacheList = businessPolicyProductService.findCacheList(cacheKey);
        if(CollectionUtils.isEmpty(cacheList)){
            return 0;
        }
        Integer total = cacheList.size();
        Validate.isTrue(total < CommonConstant.IE_EXPORT_MAX_TOTAL, "导出时，" +
                "单次最大导出[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]条,请输入更多查询条件!!");
        return total;
    }

    private String getFromCacheKey(Map<String, Object> params) {
        String cacheKey = (String)params.get("cacheKey");
        Validate.isTrue(!StringUtils.isEmpty(cacheKey),"缓存key不能空");
        return cacheKey;
    }

    @Override
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        String cacheKey = getFromCacheKey(params);
        List<BusinessPolicyProductDto> cacheList = businessPolicyProductService.findCacheList(cacheKey);
        String s = JsonUtils.obj2JsonString(cacheList);
        return JSONArray.parseArray(s);
    }

    @Override
    public String getBusinessCode() {
        return "policy_product_exports_process";
    }

    @Override
    public String getBusinessName() {
        return "促销政策产品导出";
    }

}
