package com.biz.crm.tpm.business.business.policy.local.exports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author : dengwei
 * @Date :2023/7/3  15:49
 * @Description: 促销政策范围导出
 */
@ApiModel("促销政策范围导出")
@Data
@CrmExcelExport
public class BusinessPolicyScopeExportVo extends CrmExcelVo implements Serializable {

    @ApiModelProperty("客户等级(客户分级)")
    @CrmExcelColumn(value = "客户等级(客户分级)")
    private String customerGrade;

    @ApiModelProperty("客户合同量")
    @CrmExcelColumn(value = "客户合同量")
    private String customerContractQuantity;

    @ApiModelProperty("基础返点(旬返)")
    @CrmExcelColumn(value = "基础返点(旬返)")
    private BigDecimal baseTenDayReturnPoint;

    @ApiModelProperty("基础返点(月返)")
    @CrmExcelColumn(value = "基础返点(月返)")
    private BigDecimal baseMonthReturnPoint;

    @ApiModelProperty("目标达成返点")
    @CrmExcelColumn(value = "目标达成返点")
    private BigDecimal targetConcludeReturnPoint;

    @ApiModelProperty("组合装点数")
    @CrmExcelColumn(value = "组合装点数")
    private BigDecimal combinationPoint;

    @ApiModelProperty("其他政策1-点数")
    @CrmExcelColumn(value = "其他政策1-点数")
    private BigDecimal otherPolicy1Point;

    @ApiModelProperty("其他政策2-点数")
    @CrmExcelColumn(value = "其他政策2-点数")
    private BigDecimal otherPolicy2Point;

    @ApiModelProperty("其他政策3-点数")
    @CrmExcelColumn(value = "其他政策3-点数")
    private BigDecimal otherPolicy3Point;

    @ApiModelProperty("其他政策4-价格")
    @CrmExcelColumn(value = "其他政策4-价格")
    private BigDecimal otherPolicy4Price;

    @ApiModelProperty("基础运营")
    @CrmExcelColumn(value = "基础运营")
    private BigDecimal baseOperation;

    @ApiModelProperty("人员费用")
    @CrmExcelColumn(value = "人员费用")
    private BigDecimal peopleFee;

    @ApiModelProperty("投放费用")
    @CrmExcelColumn(value = "投放费用")
    private BigDecimal putFee;

    @ApiModelProperty("物流费用")
    @CrmExcelColumn(value = "物流费用")
    private BigDecimal logisticsFee;

    @ApiModelProperty("季度返")
    @CrmExcelColumn(value = "季度返")
    private BigDecimal quarterReturn;

    @ApiModelProperty("年返兑现")
    @CrmExcelColumn(value = "年返兑现")
    private BigDecimal yearReturnCash;
}
