package com.biz.crm.tpm.business.business.policy.local.exports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author : dengwei
 * @Date :2023/7/3  11:50
 * @Description: 商务政策产品导出
 */
@ApiModel("商务政策产品导出")
@Data
@CrmExcelExport
public class PolicyProductExportVo extends CrmExcelVo implements Serializable {
    @CrmExcelColumn(value = "*产品编码")
    @ApiModelProperty("产品编码")
    private String productCode;

    @CrmExcelColumn(value = "产品名称")
    @ApiModelProperty(name = "产品名称", notes = "产品名称")
    private String productName;

    @CrmExcelColumn(value = "供货价(元)")
    @ApiModelProperty("供货价(元)")
    private BigDecimal offerGoodsPrice;

    @CrmExcelColumn(value = "预计销量(件)")
    @ApiModelProperty("预计销量(件)")
    private BigDecimal predictSaleQuantity;

    @CrmExcelColumn(value = "预计折前销售额(元)")
    @ApiModelProperty("预计折前销售额(元)")
    private BigDecimal predictBeforeDiscountSaleAmount;

    @CrmExcelColumn(value = "旬返-点数")
    @ApiModelProperty("旬返-点数")
    private BigDecimal tenDayReturnPoint;

    @CrmExcelColumn(value = "月返-点数")
    @ApiModelProperty("月返-点数")
    private BigDecimal monthReturnPoint;

    @CrmExcelColumn(value = "目标达成返点")
    @ApiModelProperty("目标达成返点")
    private BigDecimal targetReachReturnPoint;

    @CrmExcelColumn(value = "组合装点数")
    @ApiModelProperty("组合装点数")
    private BigDecimal combinationPoint;

    @CrmExcelColumn(value = "基础运营点数")
    @ApiModelProperty("基础运营点数")
    private BigDecimal baseOperationPoint;

    @CrmExcelColumn(value = "人员点数")
    @ApiModelProperty("人员点数")
    private BigDecimal manPoint;

    @CrmExcelColumn(value = "投放点数")
    @ApiModelProperty("投放点数")
    private BigDecimal putPoint;

    @CrmExcelColumn(value = "物流点数")
    @ApiModelProperty("物流点数")
    private BigDecimal logisticPoint;

    @CrmExcelColumn(value = "季返点数")
    @ApiModelProperty("季返点数")
    private BigDecimal quarterReturnPoint;

    @CrmExcelColumn(value = "年返点数")
    @ApiModelProperty("年返点数")
    private BigDecimal yearReturnPoint;

    @CrmExcelColumn(value = "其他政策1-点数")
    @ApiModelProperty("其他政策1-点数")
    private BigDecimal otherPolicy1Point;

    @CrmExcelColumn(value = "其他政策2-点数")
    @ApiModelProperty("其他政策2-点数")
    private BigDecimal otherPolicy2Point;

    @CrmExcelColumn(value = "其他政策3-点数")
    @ApiModelProperty("其他政策3-点数")
    private BigDecimal otherPolicy3Point;

    @CrmExcelColumn(value = "其他政策4-价格")
    @ApiModelProperty("其他政策4-价格")
    private BigDecimal otherPolicy4Price;

    @CrmExcelColumn(value = "基础返点(旬返) 费用")
    @ApiModelProperty(" 基础返点(旬返) 费用")
    private BigDecimal baseReturnPointTenDayReturnFee;

    @CrmExcelColumn(value = "基础返点(月返) 费用")
    @ApiModelProperty("基础返点(月返) 费用")
    private BigDecimal baseReturnPointMonthReturnFee;

    @CrmExcelColumn(value = "目标达成返点费用")
    @ApiModelProperty("目标达成返点费用")
    private BigDecimal targetReachReturnPointFee;

    @CrmExcelColumn(value = "组合装费用")
    @ApiModelProperty("组合装费用")
    private BigDecimal combinationFee;

    @CrmExcelColumn(value = "组合装费用")
    @ApiModelProperty("基础运营费用")
    private BigDecimal baseOperationFee;

    @CrmExcelColumn(value = "人员费用")
    @ApiModelProperty("人员费用")
    private BigDecimal peopleFee;

    @CrmExcelColumn(value = "投放费用")
    @ApiModelProperty("投放费用")
    private BigDecimal putFee;

    @CrmExcelColumn(value = "物流支持费用")
    @ApiModelProperty("物流支持费用")
    private BigDecimal logisticSupportFee;

    @CrmExcelColumn(value = "季返费用")
    @ApiModelProperty("季返费用")
    private BigDecimal quarterReturnFee;

    @CrmExcelColumn(value = "年返费用")
    @ApiModelProperty("年返费用")
    private BigDecimal yearReturnFee;

    @CrmExcelColumn(value = "其他政策1-费用")
    @ApiModelProperty("其他政策1-费用")
    private BigDecimal otherPolicy1Fee;

    @CrmExcelColumn(value = "其他政策2-费用")
    @ApiModelProperty("其他政策2-费用")
    private BigDecimal otherPolicy2Fee;

    @CrmExcelColumn(value = "其他政策3-费用")
    @ApiModelProperty("其他政策3-费用")
    private BigDecimal otherPolicy3Fee;

    @CrmExcelColumn(value = "其他政策4-费用")
    @ApiModelProperty("其他政策4-费用")
    private BigDecimal otherPolicy4Fee;

    @CrmExcelColumn(value = "费用小计")
    @ApiModelProperty("费用小计")
    private BigDecimal feeTotal;
}
