package com.biz.crm.tpm.business.business.policy.local.helper;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.business.policy.local.constants.BusinessPolicyConstants;
import com.biz.crm.tpm.business.business.policy.local.repository.BusinessPolicyProductRepository;
import com.biz.crm.tpm.business.business.policy.sdk.dto.BusinessPolicyProductDto;
import com.biz.crm.tpm.business.business.policy.sdk.vo.BusinessPolicyProductVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

/**
 * @Author : dengwei
 * @Date :2023/7/5  9:47
 * @Description: 缓存帮助类
 */
@Component
public class BusinessPolicyProductHelper extends MnPageCacheHelper<BusinessPolicyProductVo, BusinessPolicyProductDto> {

    @Autowired(required = false)
    private BusinessPolicyProductRepository businessPolicyProductRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public String getCacheKeyPrefix() {
        return BusinessPolicyConstants.BUSINESS_POLICY_PRODUCT_CACHE_KEY_PREFIX;
    }

    @Override
    public Class<BusinessPolicyProductDto> getDtoClass() {
        return BusinessPolicyProductDto.class;
    }

    @Override
    public Class<BusinessPolicyProductVo> getVoClass() {
        return BusinessPolicyProductVo.class;
    }

    @Override
    public List<BusinessPolicyProductDto> findDtoListFromRepository(BusinessPolicyProductDto dto, String cacheKey) {

        if(StringUtils.isEmpty(dto.getBusinessPolicyCode())){
            return Lists.newArrayList();
        }

        return businessPolicyProductRepository.findListByCode(dto.getBusinessPolicyCode());
    }

    @Override
    public List<BusinessPolicyProductDto> newItem(String cacheKey, List<BusinessPolicyProductDto> itemList) {

        itemList.forEach(newItem->{
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        });

        return itemList;
    }

    @Override
    public List<BusinessPolicyProductDto> copyItem(String cacheKey, List<BusinessPolicyProductDto> itemList) {
        List<BusinessPolicyProductDto> newItemList = (List<BusinessPolicyProductDto>) nebulaToolkitService.copyCollectionByBlankList(itemList, BusinessPolicyProductDto.class, BusinessPolicyProductDto.class, HashSet.class, ArrayList.class);
        for (BusinessPolicyProductDto newItem : newItemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }
        return newItemList;
    }

    @Override
    public Object getDtoKey(BusinessPolicyProductDto dto) {
        return dto.getId();
    }

    @Override
    public String getCheckedStatus(BusinessPolicyProductDto dto) {
        return dto.getChecked();
    }

    @Override
    public void filterSaveItem(String cacheKey, List<Object> idList, List<BusinessPolicyProductDto> itemList, List<BusinessPolicyProductDto> updateList){

        List<String> productCodes = updateList.stream().map(BusinessPolicyProductDto::getProductCode).collect(Collectors.toList());
        itemList = itemList.stream().filter(item -> !idList.contains(this.getDtoKey(item))).filter(item->!productCodes.contains(item.getProductCode())).collect(Collectors.toList());
    }
}
