package com.biz.crm.tpm.business.business.policy.local.imports;

import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.tpm.business.business.policy.local.constants.BusinessPolicyConstants;
import com.biz.crm.tpm.business.business.policy.local.imports.vo.BusinessPolicyScopeImportVo;
import com.biz.crm.tpm.business.business.policy.sdk.dto.BusinessPolicyScopeDto;
import com.bizunited.nebula.common.util.JsonUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Author : dengwei
 * @Date :2023/7/3  16:08
 * @Description: 促销政策范围导入
 */
@Slf4j
@Component
public class BusinessPolicyScopeImportProcess implements ImportProcess<BusinessPolicyScopeImportVo> {

    @Autowired(required = false)
    private RedisService redisService;
    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, BusinessPolicyScopeImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        String cacheKey = (String)params.get("cacheKey");
        Validate.isTrue(!StringUtils.isEmpty(cacheKey),"缓存key不能空");

        log.info("商务政策导入数据{}", JsonUtils.obj2JsonString(data.values()));

        List<BusinessPolicyScopeDto> buildData = buildData(data);

        log.info("商务政策导入构建后数据{}",JsonUtils.obj2JsonString(buildData));
        redisService.set(BusinessPolicyConstants.BUSINESS_POLICY_SCOPE_PRE +cacheKey,buildData,300);
        return null;
    }

    private List<BusinessPolicyScopeDto> buildData(LinkedHashMap<Integer, BusinessPolicyScopeImportVo> data) {

        List<BusinessPolicyScopeDto> businessPolicyScopeDtos = new ArrayList<>();
        try {

            List<BusinessPolicyScopeImportVo> policyScopeImportVos = Lists.newArrayList(data.values());

            Map<String, List<BusinessPolicyScopeImportVo>> policyScopeImportMap = policyScopeImportVos.stream().collect(Collectors.groupingBy(BusinessPolicyScopeImportVo::getCustomerGrade));
            policyScopeImportMap.forEach((key, value) -> {
                Validate.isTrue(value.size() <= 1,"产品等级【%s】录入重复",key);
            });
            for (BusinessPolicyScopeImportVo item : policyScopeImportVos) {
                BusinessPolicyScopeDto businessPolicyScopeDto = new BusinessPolicyScopeDto();
                BeanUtils.copyProperties(item,businessPolicyScopeDto);
                amountTransform(item,businessPolicyScopeDto);
                businessPolicyScopeDtos.add(businessPolicyScopeDto);
            }

        }catch (Exception e){
            log.error(e.getMessage(),e);
            String errorMsg = e.getMessage();
            if (StringUtils.isEmpty(e.getMessage())){
                errorMsg = "数据处理失败！";
            }
            throw new IllegalArgumentException(errorMsg);
        }
        return businessPolicyScopeDtos;
    }

    private void amountTransform(BusinessPolicyScopeImportVo item, BusinessPolicyScopeDto dto) throws InvocationTargetException, IllegalAccessException {
        PropertyDescriptor[] bpsis = BeanUtils.getPropertyDescriptors(BusinessPolicyScopeImportVo.class);
        PropertyDescriptor[] bpsds = BeanUtils.getPropertyDescriptors(BusinessPolicyScopeDto.class);
        Map<String, PropertyDescriptor> bpsdsMap = Arrays.stream(bpsds).collect(Collectors.toMap(FeatureDescriptor::getName, Function.identity()));
        for (PropertyDescriptor bpsi : bpsis) {
            Object bpsiValue = bpsi.getReadMethod().invoke(item);
            if(Objects.isNull(bpsiValue)){
                continue;
            }
            String propertyName = bpsi.getName();
            PropertyDescriptor bpsd = bpsdsMap.get(propertyName);
            if(!bpsi.getPropertyType().equals(bpsd.getPropertyType())){
                if(bpsi.getPropertyType().equals(String.class)&&bpsd.getPropertyType().equals(BigDecimal.class)){
                    bpsd.getWriteMethod().invoke(dto,new BigDecimal((String) bpsiValue));
                }
            }
        }

    }

    @Override
    public Integer getBatchCount(){
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<BusinessPolicyScopeImportVo> findCrmExcelVoClass() {
        return BusinessPolicyScopeImportVo.class;
    }

    @Override
    public String getTemplateCode() {
        return "business_policy_scope_import_process";
    }

    @Override
    public String getTemplateName() {
        return "促销政策范围导入";
    }

    public List<BusinessPolicyScopeDto> getPolicyScope(String cacheKey) {
        log.info("促销政策范围导入查询数据:cacheKey:{}",cacheKey);
        List<BusinessPolicyScopeDto> o = (List<BusinessPolicyScopeDto>)redisService.get(BusinessPolicyConstants.BUSINESS_POLICY_SCOPE_PRE + cacheKey);
        log.info("促销政策范围导入查询数据:o:{}",JsonUtils.obj2JsonString(o));
        return o;
    }
}
