package com.biz.crm.tpm.business.business.policy.local.imports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @Author : dengwei
 * @Date :2023/7/3  16:09
 * @Description: 商务政策范围导入
 */
@Data
@CrmExcelImport(startRow = 1)
@ApiModel("商务政策范围导入vo")
public class BusinessPolicyScopeImportVo extends CrmExcelVo implements Serializable {
    @ApiModelProperty("客户等级(客户分级)")
    @CrmExcelColumn(value = "客户等级(客户分级)")
    private String customerGrade;

    @ApiModelProperty("客户合同量")
    @CrmExcelColumn(value = "客户合同量")
    private String customerContractQuantity;

    @ApiModelProperty("基础返点(旬返)")
    @CrmExcelColumn(value = "基础返点(旬返)")
    private String baseTenDayReturnPoint;

    @ApiModelProperty("基础返点(月返)")
    @CrmExcelColumn(value = "基础返点(月返)")
    private String baseMonthReturnPoint;

    @ApiModelProperty("目标达成返点")
    @CrmExcelColumn(value = "目标达成返点")
    private String targetConcludeReturnPoint;

    @ApiModelProperty("组合装点数")
    @CrmExcelColumn(value = "组合装点数")
    private String combinationPoint;

    @ApiModelProperty("其他政策1-点数")
    @CrmExcelColumn(value = "其他政策1-点数")
    private String otherPolicy1Point;

    @ApiModelProperty("其他政策2-点数")
    @CrmExcelColumn(value = "其他政策2-点数")
    private String otherPolicy2Point;

    @ApiModelProperty("其他政策3-点数")
    @CrmExcelColumn(value = "其他政策3-点数")
    private String otherPolicy3Point;

    @ApiModelProperty("其他政策4-价格")
    @CrmExcelColumn(value = "其他政策4-价格")
    private String otherPolicy4Price;

    @ApiModelProperty("基础运营")
    @CrmExcelColumn(value = "基础运营")
    private String baseOperation;

    @ApiModelProperty("人员费用")
    @CrmExcelColumn(value = "人员费用")
    private String peopleFee;

    @ApiModelProperty("投放费用")
    @CrmExcelColumn(value = "投放费用")
    private String putFee;

    @ApiModelProperty("物流费用")
    @CrmExcelColumn(value = "物流费用")
    private String logisticsFee;

    @ApiModelProperty("季度返")
    @CrmExcelColumn(value = "季度返")
    private String quarterReturn;

    @ApiModelProperty("年返兑现")
    @CrmExcelColumn(value = "年返兑现")
    private String yearReturnCash;
}
