package com.biz.crm.tpm.business.business.policy.local.imports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Description: 客户vo
 * @Author: dengwei
 * @Date: 2023/2/2 17:29
 * @Version: 1.0
 */
@Data
@CrmExcelImport(startRow = 1)
@ApiModel("商务政策客户导入VO")
public class PolicyProductImportVo extends CrmExcelVo implements Serializable {

    @CrmExcelColumn(value = "*产品编码")
    @ApiModelProperty("产品编码")
    private String productCode;

    @CrmExcelColumn(value = "产品名称")
    @ApiModelProperty(name = "产品名称", notes = "产品名称")
    private String productName;

    @ApiModelProperty("供货价(元)")
    @CrmExcelColumn(value = "供货价(元)")
    private String offerGoodsPrice;

    @ApiModelProperty("预计销量(件)")
    @CrmExcelColumn(value = "预计销量(件)")
    private String predictSaleQuantity;

    @ApiModelProperty("预计折前销售额(元)")
    @CrmExcelColumn(value = "预计折前销售额(元)")
    private String predictBeforeDiscountSaleAmount;

    @ApiModelProperty("旬返-点数")
    @CrmExcelColumn(value = "旬返-点数")
    private String tenDayReturnPoint;

    @ApiModelProperty("月返-点数")
    @CrmExcelColumn(value = "月返-点数")
    private String monthReturnPoint;

    @ApiModelProperty("目标达成返点")
    @CrmExcelColumn(value = "目标达成返点")
    private String targetReachReturnPoint;

    @ApiModelProperty("组合装点数")
    @CrmExcelColumn(value = "组合装点数")
    private String combinationPoint;

    @ApiModelProperty("基础运营点数")
    @CrmExcelColumn(value = "基础运营点数")
    private String baseOperationPoint;

    @ApiModelProperty("人员点数")
    @CrmExcelColumn(value = "人员点数")
    private BigDecimal manPoint;

    @ApiModelProperty("投放点数")
    @CrmExcelColumn(value = "投放点数")
    private String putPoint;

    @ApiModelProperty("物流点数")
    @CrmExcelColumn(value = "物流点数")
    private String logisticPoint;

    @ApiModelProperty("季返点数")
    @CrmExcelColumn(value = "季返点数")
    private String quarterReturnPoint;

    @ApiModelProperty("年返点数")
    @CrmExcelColumn(value = "年返点数")
    private String yearReturnPoint;

    @ApiModelProperty("其他政策1-点数")
    @CrmExcelColumn(value = "其他政策1-点数")
    private String otherPolicy1Point;

    @ApiModelProperty("其他政策2-点数")
    @CrmExcelColumn(value = "其他政策2-点数")
    private String otherPolicy2Point;

    @ApiModelProperty("其他政策3-点数")
    @CrmExcelColumn(value = "其他政策3-点数")
    private String otherPolicy3Point;

    @ApiModelProperty("其他政策4-价格")
    @CrmExcelColumn(value = "其他政策4-价格")
    private String otherPolicy4Price;

    @ApiModelProperty(" 基础返点(旬返) 费用")
    @CrmExcelColumn(value = "基础返点(旬返) 费用")
    private String baseReturnPointTenDayReturnFee;

    @ApiModelProperty("基础返点(月返) 费用")
    @CrmExcelColumn(value = "基础返点(月返) 费用")
    private String baseReturnPointMonthReturnFee;

    @ApiModelProperty("目标达成返点费用")
    @CrmExcelColumn(value = "目标达成返点费用")
    private String targetReachReturnPointFee;

    @ApiModelProperty("组合装费用")
    @CrmExcelColumn(value = "组合装费用")
    private String combinationFee;

    @ApiModelProperty("基础运营费用")
    @CrmExcelColumn(value = "基础运营费用")
    private String baseOperationFee;

    @ApiModelProperty("人员费用")
    @CrmExcelColumn(value = "人员费用")
    private String peopleFee;

    @ApiModelProperty("投放费用")
    @CrmExcelColumn(value = "投放费用")
    private String putFee;

    @ApiModelProperty("物流支持费用")
    @CrmExcelColumn(value = "物流支持费用")
    private String logisticSupportFee;

    @ApiModelProperty("季返费用")
    @CrmExcelColumn(value = "季返费用")
    private String quarterReturnFee;

    @ApiModelProperty("年返费用")
    @CrmExcelColumn(value = "年返费用")
    private String yearReturnFee;

    @ApiModelProperty("其他政策1-费用")
    @CrmExcelColumn(value = "其他政策1-费用")
    private String otherPolicy1Fee;

    @ApiModelProperty("其他政策2-费用")
    @CrmExcelColumn(value = "其他政策2-费用")
    private String otherPolicy2Fee;

    @ApiModelProperty("其他政策3-费用")
    @CrmExcelColumn(value = "其他政策3-费用")
    private String otherPolicy3Fee;

    @ApiModelProperty("其他政策4-费用")
    @CrmExcelColumn(value = "其他政策4-费用")
    private String otherPolicy4Fee;

    @ApiModelProperty("费用小计")
    @CrmExcelColumn(value = "费用小计")
    private String feeTotal;
}
