package com.biz.crm.tpm.business.business.policy.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.business.policy.local.entity.BusinessPolicy;
import com.biz.crm.tpm.business.business.policy.sdk.dto.BusinessPolicyDto;
import com.biz.crm.tpm.business.business.policy.sdk.vo.BusinessPolicyVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 商务政策主表(BusinessPolicy)表mybatis访问层
 *
 * @author makejava
 * @since 2022-11-05 11:29:46
 */
public interface BusinessPolicyMapper extends BaseMapper<BusinessPolicy> {

    /**
     * 分页查询所有数据
     *
     * @param page           分页对象
     * @param businessPolicy 查询实体
     * @return 所有数据
     */
    public Page<BusinessPolicyVo> findByConditions(@Param("page") Page<BusinessPolicyVo> page, @Param("businessPolicy") BusinessPolicyDto businessPolicy);

    void updateBusinessPolicyApplyAmount(@Param("voList") List<BusinessPolicyVo> voList);

    void updateBusinessPolicyByAuditPass(@Param("dtoList") List<BusinessPolicyDto> businessPolicyDtoList);

}

