package com.biz.crm.tpm.business.business.policy.local.repository;



import com.biz.crm.tpm.business.business.policy.local.entity.BusinessPolicyBudget;
import com.biz.crm.tpm.business.business.policy.local.mapper.BusinessPolicyBudgetMapper;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;


/**
 * 商务政策预算信息(BusinessPolicyBudget)表数据库访问层
 *
 * @author makejava
 * @since 2022-11-05 11:29:46
 */
@Component
public class BusinessPolicyBudgetRepository extends ServiceImpl<BusinessPolicyBudgetMapper, BusinessPolicyBudget> {

  @Autowired
  private BusinessPolicyBudgetMapper businessPolicyBudgetMapper;
  
   /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param businessPolicyBudget 实体对象
   * @return
   */
  public Page<BusinessPolicyBudget> findByConditions(Pageable pageable, BusinessPolicyBudget businessPolicyBudget) {
    Page<BusinessPolicyBudget> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<BusinessPolicyBudget> pageList = this.businessPolicyBudgetMapper.findByConditions(page, businessPolicyBudget);
    return pageList;
  }
}

