package com.biz.crm.tpm.business.business.policy.local.repository;



import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.business.policy.local.entity.BusinessPolicyProduct;
import com.biz.crm.tpm.business.business.policy.local.mapper.BusinessPolicyProductMapper;
import com.biz.crm.tpm.business.business.policy.sdk.dto.BusinessPolicyProductDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;


/**
 * 商务政策考核产品(BusinessPolicyProduct)表数据库访问层
 *
 * @author makejava
 * @since 2022-11-05 11:29:45
 */
@Component
public class BusinessPolicyProductRepository extends ServiceImpl<BusinessPolicyProductMapper, BusinessPolicyProduct> {

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Autowired(required = false)
  private BusinessPolicyProductMapper businessPolicyProductMapper;
  
   /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param businessPolicyProduct 实体对象
   * @return
   */
  public Page<BusinessPolicyProduct> findByConditions(Pageable pageable, BusinessPolicyProduct businessPolicyProduct) {
    Page<BusinessPolicyProduct> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<BusinessPolicyProduct> pageList = this.businessPolicyProductMapper.findByConditions(page, businessPolicyProduct);
    return pageList;
  }

  public List<BusinessPolicyProductDto> findListByCode(String businessPolicyCode) {
    if(StringUtils.isEmpty(businessPolicyCode)){
      return Lists.newArrayList();
    }

    List<BusinessPolicyProduct> list = this.lambdaQuery()
            .eq(BusinessPolicyProduct::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
            .eq(BusinessPolicyProduct::getTenantCode, TenantUtils.getTenantCode())
            .eq(BusinessPolicyProduct::getBusinessPolicyCode, businessPolicyCode).list();

    Collection<BusinessPolicyProductDto> businessPolicyProductDtos = this.nebulaToolkitService.copyCollectionByWhiteList(list, BusinessPolicyProduct.class, BusinessPolicyProductDto.class, LinkedHashSet.class, ArrayList.class);
    return (List<BusinessPolicyProductDto>) businessPolicyProductDtos;
  }
}

