package com.biz.crm.tpm.business.business.policy.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.business.policy.local.entity.BusinessPolicy;
import com.biz.crm.tpm.business.business.policy.local.mapper.BusinessPolicyMapper;
import com.biz.crm.tpm.business.business.policy.sdk.dto.BusinessPolicyDto;
import com.biz.crm.tpm.business.business.policy.sdk.vo.BusinessPolicyVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;


/**
 * 商务政策主表(BusinessPolicy)表数据库访问层
 *
 * @author makejava
 * @since 2022-11-05 11:29:46
 */
@Component
public class BusinessPolicyRepository extends ServiceImpl<BusinessPolicyMapper, BusinessPolicy> {

    @Autowired(required = false)
    private BusinessPolicyMapper businessPolicyMapper;

    /**
     * 分页查询数据
     *
     * @param pageable       分页对象
     * @param businessPolicy 实体对象
     * @return
     */
    public Page<BusinessPolicyVo> findByConditions(Pageable pageable, BusinessPolicyDto businessPolicy) {
        Page<BusinessPolicyVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<BusinessPolicyVo> pageList = this.businessPolicyMapper.findByConditions(page, businessPolicy);
        return pageList;
    }

    /**
     * 申请金额修改
     *
     * @param voList
     */
    public void updateBusinessPolicyApplyAmount(List<BusinessPolicyVo> voList) {
        businessPolicyMapper.updateBusinessPolicyApplyAmount(voList);
    }

    public void updateBusinessPolicyByAuditPass(List<BusinessPolicyDto> businessPolicyDtoList) {
        businessPolicyMapper.updateBusinessPolicyByAuditPass(businessPolicyDtoList);
    }
}

