package com.biz.crm.tpm.business.business.policy.local.repository;



import com.biz.crm.tpm.business.business.policy.local.entity.BusinessPolicyScope;
import com.biz.crm.tpm.business.business.policy.local.mapper.BusinessPolicyScopeMapper;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;


/**
 * 政策范围(BusinessPolicyScope)表数据库访问层
 *
 * @author makejava
 * @since 2022-11-05 11:29:45
 */
@Component
public class BusinessPolicyScopeRepository extends ServiceImpl<BusinessPolicyScopeMapper, BusinessPolicyScope> {

  @Autowired
  private BusinessPolicyScopeMapper businessPolicyScopeMapper;
  
   /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param businessPolicyScope 实体对象
   * @return
   */
  public Page<BusinessPolicyScope> findByConditions(Pageable pageable, BusinessPolicyScope businessPolicyScope) {
    Page<BusinessPolicyScope> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<BusinessPolicyScope> pageList = this.businessPolicyScopeMapper.findByConditions(page, businessPolicyScope);
    return pageList;
  }
}

