package com.biz.crm.tpm.business.business.policy.local.service;


import com.biz.crm.tpm.business.business.policy.local.entity.BusinessPolicyBudget;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.data.domain.Pageable;
import java.util.List;

/**
 * 商务政策预算信息(BusinessPolicyBudget)表服务接口
 *
 * @author makejava
 * @since 2022-11-05 11:29:46
 */
public interface BusinessPolicyBudgetService{

  /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param businessPolicyBudget 实体对象
   * @return
   */
  Page<BusinessPolicyBudget> findByConditions(Pageable pageable, BusinessPolicyBudget businessPolicyBudget);
  
   /**
   * 通过主键查询单条数据
   * @param id 主键
   * @return 单条数据
   */
  BusinessPolicyBudget findById(String id);
  
   /**
   * 新增数据
   * @param businessPolicyBudget 实体对象
   * @return 新增结果
   */
  BusinessPolicyBudget create(BusinessPolicyBudget businessPolicyBudget);
  
   /**
   * 修改新据
   * @param businessPolicyBudget 实体对象
   * @return 修改结果
   */
  BusinessPolicyBudget update(BusinessPolicyBudget businessPolicyBudget);
  
  /**
   * 删除数据
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);

}

