package com.biz.crm.tpm.business.business.policy.local.service;


import com.biz.crm.mn.common.page.cache.service.MnPageCacheService;
import com.biz.crm.tpm.business.business.policy.local.entity.BusinessPolicyProduct;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.business.policy.sdk.dto.BusinessPolicyProductDto;
import com.biz.crm.tpm.business.business.policy.sdk.vo.BusinessPolicyProductVo;
import org.springframework.data.domain.Pageable;
import java.util.List;

/**
 * 商务政策考核产品(BusinessPolicyProduct)表服务接口
 *
 * @author makejava
 * @since 2022-11-05 11:29:45
 */
public interface BusinessPolicyProductService extends MnPageCacheService<BusinessPolicyProductVo, BusinessPolicyProductDto> {

  /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param businessPolicyProduct 实体对象
   * @return
   */
  Page<BusinessPolicyProduct> findByConditions(Pageable pageable, BusinessPolicyProduct businessPolicyProduct);
  
   /**
   * 通过主键查询单条数据
   * @param id 主键
   * @return 单条数据
   */
  BusinessPolicyProduct findById(String id);
  
   /**
   * 新增数据
   * @param businessPolicyProduct 实体对象
   * @return 新增结果
   */
  BusinessPolicyProduct create(BusinessPolicyProduct businessPolicyProduct);
  
   /**
   * 修改新据
   * @param businessPolicyProduct 实体对象
   * @return 修改结果
   */
  BusinessPolicyProduct update(BusinessPolicyProduct businessPolicyProduct);
  
  /**
   * 删除数据
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);

}

