package com.biz.crm.tpm.business.business.policy.local.service;


import com.biz.crm.tpm.business.business.policy.local.entity.BusinessPolicyScope;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.data.domain.Pageable;
import java.util.List;

/**
 * 政策范围(BusinessPolicyScope)表服务接口
 *
 * @author makejava
 * @since 2022-11-05 11:29:43
 */
public interface BusinessPolicyScopeService{

  /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param businessPolicyScope 实体对象
   * @return
   */
  Page<BusinessPolicyScope> findByConditions(Pageable pageable, BusinessPolicyScope businessPolicyScope);
  
   /**
   * 通过主键查询单条数据
   * @param id 主键
   * @return 单条数据
   */
  BusinessPolicyScope findById(String id);
  
   /**
   * 新增数据
   * @param businessPolicyScope 实体对象
   * @return 新增结果
   */
  BusinessPolicyScope create(BusinessPolicyScope businessPolicyScope);
  
   /**
   * 修改新据
   * @param businessPolicyScope 实体对象
   * @return 修改结果
   */
  BusinessPolicyScope update(BusinessPolicyScope businessPolicyScope);
  
  /**
   * 删除数据
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);

}

