package com.biz.crm.tpm.business.business.policy.local.service.internal;



import com.biz.crm.tpm.business.business.policy.local.repository.BusinessPolicyBudgetRepository;
import com.biz.crm.tpm.business.business.policy.local.entity.BusinessPolicyBudget;
import com.biz.crm.tpm.business.business.policy.local.service.BusinessPolicyBudgetService;
import org.springframework.stereotype.Service;
import org.springframework.beans.factory.annotation.Autowired;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * 商务政策预算信息(BusinessPolicyBudget)表服务实现类
 *
 * @author makejava
 * @since 2022-11-05 11:29:46
 */
@Service("businessPolicyBudgetService")
public class BusinessPolicyBudgetServiceImpl implements BusinessPolicyBudgetService {

  @Autowired
  private BusinessPolicyBudgetRepository businessPolicyBudgetRepository;

  /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param businessPolicyBudget 实体对象
   * @return
   */
  @Override
  public Page<BusinessPolicyBudget> findByConditions(Pageable pageable, BusinessPolicyBudget businessPolicyBudget) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
    if (Objects.isNull(businessPolicyBudget)) {
      businessPolicyBudget = new BusinessPolicyBudget();
    }
    return this.businessPolicyBudgetRepository.findByConditions(pageable, businessPolicyBudget);
  }
  
  /**
   * 通过主键查询单条数据
   * @param id 主键
   * @return 单条数据
   */
  @Override
  public BusinessPolicyBudget findById(String id) {
    if (StringUtils.isBlank(id)) {
	  return null;
	}
    return this.businessPolicyBudgetRepository.getById(id);
  }
  
  /**
   * 新增数据
   * @param businessPolicyBudget 实体对象
   * @return 新增结果
   */
  @Transactional
  @Override
  public BusinessPolicyBudget create(BusinessPolicyBudget businessPolicyBudget) {
    this.createValidate(businessPolicyBudget);
    this.businessPolicyBudgetRepository.saveOrUpdate(businessPolicyBudget);
    return businessPolicyBudget;
  }
  
  /**
   * 修改新据
   * @param businessPolicyBudget 实体对象
   * @return 修改结果
   */
  @Transactional
  @Override
  public BusinessPolicyBudget update(BusinessPolicyBudget businessPolicyBudget) {
    this.updateValidate(businessPolicyBudget);
    this.businessPolicyBudgetRepository.saveOrUpdate(businessPolicyBudget);
    return businessPolicyBudget;
  }
  
  /**
   * 删除数据
   * @param idList 主键结合
   * @return 删除结果
   */
  @Transactional
  @Override
  public void delete(List<String> idList) {
    Validate.isTrue(!CollectionUtils.isEmpty(idList), "删除数据时，主键集合不能为空！");
    this.businessPolicyBudgetRepository.removeByIds(idList);
  }
  
  /**
   * 创建验证
   * @param businessPolicyBudget
   */
  private void createValidate(BusinessPolicyBudget businessPolicyBudget) {
    Validate.notNull(businessPolicyBudget, "新增时，对象信息不能为空！");
	businessPolicyBudget.setId(null);
      Validate.notBlank(businessPolicyBudget.getTenantCode(), "新增数据时，租户编号不能为空！");
    Validate.notBlank(businessPolicyBudget.getFeeBelongCode(), "新增数据时，费用归口[数据字典:tpm_fee_belong] 不能为空！");
   
  }
  
   /**
   * 修改验证
   * @param businessPolicyBudget
   */
  private void updateValidate(BusinessPolicyBudget businessPolicyBudget) {
    Validate.notNull(businessPolicyBudget, "修改时，对象信息不能为空！");
      Validate.notBlank(businessPolicyBudget.getId(), "新增数据时，不能为空！");
    Validate.notBlank(businessPolicyBudget.getTenantCode(), "新增数据时，租户编号不能为空！");
    Validate.notBlank(businessPolicyBudget.getFeeBelongCode(), "新增数据时，费用归口[数据字典:tpm_fee_belong] 不能为空！");
    
  }
}

