package com.biz.crm.tpm.business.business.policy.local.service.internal;


import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.business.policy.sdk.constant.BusinessPolicyConstant;
import com.biz.crm.tpm.business.business.policy.sdk.service.BusinessPolicyLockService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

/**
 * 商务政策主表(BusinessPolicy)表服务实现类
 *
 * @author makejava
 * @since 2022-11-05 11:29:46
 */
@Slf4j
@Service
public class BusinessPolicyLockServiceImpl implements BusinessPolicyLockService {


    @Autowired(required = false)
    private RedisLockService redisLockService;

    /**
     * 加锁
     *
     * @param code
     * @param timeUnit
     * @param time
     * @return boolean
     * @author huojia
     * @date 2022/11/1 21:03
     **/
    @Override
    public boolean lock(String code, TimeUnit timeUnit, int time) {
        Assert.hasLength(code, "商务政策加锁失败，编码不能为空!");
        return this.lock(Collections.singletonList(code), timeUnit, time);
    }

    /**
     * 加锁
     *
     * @param codeList
     * @param timeUnit
     * @param time
     * @return boolean
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-09-22 14:53
     */
    @Override
    public boolean lock(List<String> codeList, TimeUnit timeUnit, int time) {
        Assert.notEmpty(codeList, "商务政策加锁失败，编码不能为空!");
        if (Objects.isNull(timeUnit)) {
            timeUnit = TimeUnit.MINUTES;
        }
        if (time < 1) {
            time = 3;
        }
        return redisLockService.batchLock(BusinessPolicyConstant.TPM_BUSINESS_POLICY_LOCK, codeList,
                timeUnit, time);
    }

    /**
     * 解锁
     *
     * @param code
     * @return boolean
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-09-22 14:53
     */
    @Override
    public void unlock(String code) {
        if (StringUtils.isEmpty(code)) {
            return;
        }
        this.unlock(Collections.singletonList(code));
    }

    /**
     * 解锁
     *
     * @param codeList
     * @return boolean
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-09-22 14:53
     */
    @Override
    public void unlock(List<String> codeList) {
        if (CollectionUtil.isEmpty(codeList)) {
            return;
        }
        redisLockService.batchUnLock(BusinessPolicyConstant.TPM_BUSINESS_POLICY_LOCK, codeList);
    }
}

