package com.biz.crm.tpm.business.business.policy.local.service.internal;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.common.page.cache.service.internal.MnPageCacheServiceImpl;
import com.biz.crm.tpm.business.business.policy.local.entity.BusinessPolicyProduct;
import com.biz.crm.tpm.business.business.policy.local.repository.BusinessPolicyProductRepository;
import com.biz.crm.tpm.business.business.policy.local.service.BusinessPolicyProductService;
import com.biz.crm.tpm.business.business.policy.sdk.dto.BusinessPolicyProductDto;
import com.biz.crm.tpm.business.business.policy.sdk.vo.BusinessPolicyProductVo;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * 商务政策考核产品(BusinessPolicyProduct)表服务实现类
 *
 * @author makejava
 * @since 2022-11-05 11:29:45
 */
@Service("businessPolicyProductService")
public class BusinessPolicyProductServiceImpl extends MnPageCacheServiceImpl<BusinessPolicyProductVo, BusinessPolicyProductDto> implements BusinessPolicyProductService {

  @Autowired
  private BusinessPolicyProductRepository businessPolicyProductRepository;

  /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param businessPolicyProduct 实体对象
   * @return
   */
  @Override
  public Page<BusinessPolicyProduct> findByConditions(Pageable pageable, BusinessPolicyProduct businessPolicyProduct) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
    if (Objects.isNull(businessPolicyProduct)) {
      businessPolicyProduct = new BusinessPolicyProduct();
    }
    return this.businessPolicyProductRepository.findByConditions(pageable, businessPolicyProduct);
  }
  
  /**
   * 通过主键查询单条数据
   * @param id 主键
   * @return 单条数据
   */
  @Override
  public BusinessPolicyProduct findById(String id) {
    if (StringUtils.isBlank(id)) {
	  return null;
	}
    return this.businessPolicyProductRepository.getById(id);
  }
  
  /**
   * 新增数据
   * @param businessPolicyProduct 实体对象
   * @return 新增结果
   */
  @Transactional
  @Override
  public BusinessPolicyProduct create(BusinessPolicyProduct businessPolicyProduct) {
    this.createValidate(businessPolicyProduct);
    this.businessPolicyProductRepository.saveOrUpdate(businessPolicyProduct);
    return businessPolicyProduct;
  }
  
  /**
   * 修改新据
   * @param businessPolicyProduct 实体对象
   * @return 修改结果
   */
  @Transactional
  @Override
  public BusinessPolicyProduct update(BusinessPolicyProduct businessPolicyProduct) {
    this.updateValidate(businessPolicyProduct);
    this.businessPolicyProductRepository.saveOrUpdate(businessPolicyProduct);
    return businessPolicyProduct;
  }
  
  /**
   * 删除数据
   * @param idList 主键结合
   * @return 删除结果
   */
  @Transactional
  @Override
  public void delete(List<String> idList) {
    Validate.isTrue(!CollectionUtils.isEmpty(idList), "删除数据时，主键集合不能为空！");
    this.businessPolicyProductRepository.removeByIds(idList);
  }
  
  /**
   * 创建验证
   * @param businessPolicyProduct
   */
  private void createValidate(BusinessPolicyProduct businessPolicyProduct) {
    Validate.notNull(businessPolicyProduct, "新增时，对象信息不能为空！");
	businessPolicyProduct.setId(null);
      Validate.notBlank(businessPolicyProduct.getTenantCode(), "新增数据时，租户编号不能为空！");
   
  }
  
   /**
   * 修改验证
   * @param businessPolicyProduct
   */
  private void updateValidate(BusinessPolicyProduct businessPolicyProduct) {
    Validate.notNull(businessPolicyProduct, "修改时，对象信息不能为空！");
      Validate.notBlank(businessPolicyProduct.getId(), "新增数据时，不能为空！");
    Validate.notBlank(businessPolicyProduct.getTenantCode(), "新增数据时，租户编号不能为空！");
    
  }
}

