package com.biz.crm.tpm.business.business.policy.local.service.internal;



import com.biz.crm.tpm.business.business.policy.local.repository.BusinessPolicyScopeRepository;
import com.biz.crm.tpm.business.business.policy.local.entity.BusinessPolicyScope;
import com.biz.crm.tpm.business.business.policy.local.service.BusinessPolicyScopeService;
import org.springframework.stereotype.Service;
import org.springframework.beans.factory.annotation.Autowired;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * 政策范围(BusinessPolicyScope)表服务实现类
 *
 * @author makejava
 * @since 2022-11-05 11:29:43
 */
@Service("businessPolicyScopeService")
public class BusinessPolicyScopeServiceImpl implements BusinessPolicyScopeService {

  @Autowired
  private BusinessPolicyScopeRepository businessPolicyScopeRepository;

  /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param businessPolicyScope 实体对象
   * @return
   */
  @Override
  public Page<BusinessPolicyScope> findByConditions(Pageable pageable, BusinessPolicyScope businessPolicyScope) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
    if (Objects.isNull(businessPolicyScope)) {
      businessPolicyScope = new BusinessPolicyScope();
    }
    return this.businessPolicyScopeRepository.findByConditions(pageable, businessPolicyScope);
  }
  
  /**
   * 通过主键查询单条数据
   * @param id 主键
   * @return 单条数据
   */
  @Override
  public BusinessPolicyScope findById(String id) {
    if (StringUtils.isBlank(id)) {
	  return null;
	}
    return this.businessPolicyScopeRepository.getById(id);
  }
  
  /**
   * 新增数据
   * @param businessPolicyScope 实体对象
   * @return 新增结果
   */
  @Transactional
  @Override
  public BusinessPolicyScope create(BusinessPolicyScope businessPolicyScope) {
    this.createValidate(businessPolicyScope);
    this.businessPolicyScopeRepository.saveOrUpdate(businessPolicyScope);
    return businessPolicyScope;
  }
  
  /**
   * 修改新据
   * @param businessPolicyScope 实体对象
   * @return 修改结果
   */
  @Transactional
  @Override
  public BusinessPolicyScope update(BusinessPolicyScope businessPolicyScope) {
    this.updateValidate(businessPolicyScope);
    this.businessPolicyScopeRepository.saveOrUpdate(businessPolicyScope);
    return businessPolicyScope;
  }
  
  /**
   * 删除数据
   * @param idList 主键结合
   * @return 删除结果
   */
  @Transactional
  @Override
  public void delete(List<String> idList) {
    Validate.isTrue(!CollectionUtils.isEmpty(idList), "删除数据时，主键集合不能为空！");
    this.businessPolicyScopeRepository.removeByIds(idList);
  }
  
  /**
   * 创建验证
   * @param businessPolicyScope
   */
  private void createValidate(BusinessPolicyScope businessPolicyScope) {
    Validate.notNull(businessPolicyScope, "新增时，对象信息不能为空！");
	businessPolicyScope.setId(null);
      Validate.notBlank(businessPolicyScope.getTenantCode(), "新增数据时，租户编号不能为空！");
   
  }
  
   /**
   * 修改验证
   * @param businessPolicyScope
   */
  private void updateValidate(BusinessPolicyScope businessPolicyScope) {
    Validate.notNull(businessPolicyScope, "修改时，对象信息不能为空！");
      Validate.notBlank(businessPolicyScope.getId(), "新增数据时，不能为空！");
    Validate.notBlank(businessPolicyScope.getTenantCode(), "新增数据时，租户编号不能为空！");
    
  }
}

