package com.biz.crm.tpm.business.business.policy.local.service.internal;


import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.business.policy.local.constants.BusinessPolicyConstants;
import com.biz.crm.tpm.business.business.policy.local.entity.BusinessPolicy;
import com.biz.crm.tpm.business.business.policy.local.entity.BusinessPolicyBudget;
import com.biz.crm.tpm.business.business.policy.local.entity.BusinessPolicyProduct;
import com.biz.crm.tpm.business.business.policy.local.entity.BusinessPolicyScope;
import com.biz.crm.tpm.business.business.policy.local.repository.BusinessPolicyBudgetRepository;
import com.biz.crm.tpm.business.business.policy.local.repository.BusinessPolicyProductRepository;
import com.biz.crm.tpm.business.business.policy.local.repository.BusinessPolicyRepository;
import com.biz.crm.tpm.business.business.policy.local.repository.BusinessPolicyScopeRepository;
import com.biz.crm.tpm.business.business.policy.local.service.BusinessPolicyProductService;
import com.biz.crm.tpm.business.business.policy.sdk.constant.BusinessPolicyConstant;
import com.biz.crm.tpm.business.business.policy.sdk.dto.*;
import com.biz.crm.tpm.business.business.policy.sdk.dto.log.BusinessPolicyLogEventDto;
import com.biz.crm.tpm.business.business.policy.sdk.enumeration.SaveTypeEnum;
import com.biz.crm.tpm.business.business.policy.sdk.event.log.BusinessPolicyEventListener;
import com.biz.crm.tpm.business.business.policy.sdk.service.BusinessPolicyService;
import com.biz.crm.tpm.business.business.policy.sdk.vo.BusinessPolicyBudgetVo;
import com.biz.crm.tpm.business.business.policy.sdk.vo.BusinessPolicyScopeVo;
import com.biz.crm.tpm.business.business.policy.sdk.vo.BusinessPolicyVo;
import com.biz.crm.tpm.business.month.budget.sdk.constant.BudgetLockConstant;
import com.biz.crm.tpm.business.month.budget.sdk.dto.PromotionOperateMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.MonthBudgetTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetLockService;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.promotion.plan.sdk.constant.PromotionPlanConstant;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.GeneralExpensesService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.GeneralExpensesVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * 商务政策主表(BusinessPolicy)表服务实现类
 *
 * @author makejava
 * @since 2022-11-05 11:29:46
 */
@Slf4j
@Service("businessPolicyService")
public class BusinessPolicyServiceImpl implements BusinessPolicyService {

    private static final String BUSINESS_POLICY_PREFIX = "SWZC";
    @Autowired(required = false)
    private BusinessPolicyRepository businessPolicyRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    @Autowired(required = false)
    private BusinessPolicyBudgetRepository businessPolicyBudgetRepository;

    @Autowired(required = false)
    private BusinessPolicyProductRepository businessPolicyProductRepository;

    @Autowired(required = false)
    private BusinessPolicyScopeRepository businessPolicyScopeRepository;

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private ProcessBusinessService processBusinessService;

    @Autowired(required = false)
    private MonthBudgetLockService monthBudgetLockService;

    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;

    @Autowired(required = false)
    private GeneralExpensesService generalExpensesService;

    @Autowired(required = false)
    private BusinessPolicyProductService businessPolicyProductService;

    @Autowired(required = false)
    private RedisLockService redisLockService;

    /**
     * 分页查询数据
     *
     * @param pageable       分页对象
     * @param businessPolicy 实体对象
     * @return
     */
    @Override
    public Page<BusinessPolicyVo> findByConditions(Pageable pageable, BusinessPolicyDto businessPolicy) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(businessPolicy)) {
            businessPolicy = new BusinessPolicyDto();
        }
        return this.businessPolicyRepository.findByConditions(pageable, businessPolicy);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @Override
    public BusinessPolicyVo findById(String id) {
        if (StringUtils.isBlank(id)) {
            return null;
        }
        BusinessPolicy businessPolicyEntity = this.businessPolicyRepository.getById(id);

        BusinessPolicyVo businessPolicyVo = this.nebulaToolkitService.copyObjectByWhiteList(businessPolicyEntity, BusinessPolicyVo.class, null, null);

        List<BusinessPolicyBudget> list = this.businessPolicyBudgetRepository.lambdaQuery().eq(BusinessPolicyBudget::getBusinessPolicyCode, businessPolicyEntity.getBusinessPolicyCode()).list();
        if (!CollectionUtils.isEmpty(list)) {
            Collection<BusinessPolicyBudgetVo> businessPolicyBudgetVos = this.nebulaToolkitService.copyCollectionByBlankList(list, BusinessPolicyBudget.class, BusinessPolicyBudgetVo.class, LinkedHashSet.class, ArrayList.class);
            businessPolicyVo.setBusinessPolicyBudgetVoList((List<BusinessPolicyBudgetVo>) businessPolicyBudgetVos);
        }
//        List<BusinessPolicyProduct> list1 = this.businessPolicyProductRepository.lambdaQuery().eq(BusinessPolicyProduct::getBusinessPolicyCode, businessPolicyEntity.getBusinessPolicyCode()).list();
//        if (!CollectionUtils.isEmpty(list1)) {
//            Collection<BusinessPolicyProductVo> businessPolicyProductVos = this.nebulaToolkitService.copyCollectionByBlankList(list1, BusinessPolicyProduct.class, BusinessPolicyProductVo.class, LinkedHashSet.class, ArrayList.class);
//            businessPolicyVo.setBusinessPolicyProductVoList((List<BusinessPolicyProductVo>) businessPolicyProductVos);
//        }
        List<BusinessPolicyScope> list2 = this.businessPolicyScopeRepository.lambdaQuery().eq(BusinessPolicyScope::getBusinessPolicyCode, businessPolicyEntity.getBusinessPolicyCode()).list();
        if (!CollectionUtils.isEmpty(list2)) {
            Collection<BusinessPolicyScopeVo> businessPolicyScopeVos = this.nebulaToolkitService.copyCollectionByBlankList(list2, BusinessPolicyScope.class, BusinessPolicyScopeVo.class, LinkedHashSet.class, ArrayList.class);
            businessPolicyVo.setBusinessPolicyScopeVoList((List<BusinessPolicyScopeVo>) businessPolicyScopeVos);
        }
        return businessPolicyVo;
    }

    /**
     * 新增数据
     *
     * @param businessPolicy 实体对象
     * @return 新增结果
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void create(BusinessPolicyDto businessPolicy) {
        this.createValidate(businessPolicy);

        //商务政策主表
        businessPolicy.setTenantCode(TenantUtils.getTenantCode());
//        String ruleCode = StringUtils.join(BUSINESS_POLICY_PREFIX, DateFormatUtils.format(new Date(), "yyyyMMdd"));
        String code = this.generateCodeService.generateCode(BUSINESS_POLICY_PREFIX, 1, 5, 2, TimeUnit.DAYS).get(0);
        businessPolicy.setBusinessPolicyCode(code);
        businessPolicy.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
        businessPolicy.setId(null);
        BusinessPolicy businessPolicyEntity = this.nebulaToolkitService.copyObjectByWhiteList(businessPolicy, BusinessPolicy.class, null, null);
        this.businessPolicyRepository.saveOrUpdate(businessPolicyEntity);
        businessPolicy.setId(businessPolicyEntity.getId());

        //预算
        List<BusinessPolicyBudgetDto> businessPolicyBudgetDtoList = businessPolicy.getBusinessPolicyBudgetDtoList();
        if (!CollectionUtils.isEmpty(businessPolicyBudgetDtoList)) {
            businessPolicyBudgetDtoList.forEach(item -> {
                item.setBusinessPolicyCode(code);
                item.setTenantCode(TenantUtils.getTenantCode());
                item.setId(null);
                //费用率(%)：自动计算，费用率（%）=申请金额/预估销售额*100，保留6位小数
                item.setFeeRatio(item.getApplyAmount().divide(item.getEstimateSaleAmount(), 6, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100)));
            });
            Collection<BusinessPolicyBudget> businessPolicyBudgets = this.nebulaToolkitService.copyCollectionByBlankList(businessPolicyBudgetDtoList, BusinessPolicyBudgetDto.class, BusinessPolicyBudget.class, LinkedHashSet.class, ArrayList.class);
            businessPolicyBudgetRepository.saveBatch(businessPolicyBudgets);
        }
        //产品
//        List<BusinessPolicyProductDto> businessPolicyProductDtoList = businessPolicy.getBusinessPolicyProductDtoList();
        List<BusinessPolicyProductDto> businessPolicyProductDtoList = businessPolicyProductService.findCacheList(businessPolicy.getCacheKey());
        if (!CollectionUtils.isEmpty(businessPolicyBudgetDtoList)) {
            businessPolicyProductDtoList.forEach(item -> {
                item.setBusinessPolicyCode(code);
                item.setTenantCode(TenantUtils.getTenantCode());
                item.setId(null);
            });
            Collection<BusinessPolicyProduct> businessPolicyProducts = this.nebulaToolkitService.copyCollectionByBlankList(businessPolicyProductDtoList, BusinessPolicyProductDto.class, BusinessPolicyProduct.class, LinkedHashSet.class, ArrayList.class);
            businessPolicyProductRepository.saveBatch(businessPolicyProducts);
        }
        //范围
        List<BusinessPolicyScopeDto> businessPolicyScopeDtoList = businessPolicy.getBusinessPolicyScopeDtoList();
        if (!CollectionUtils.isEmpty(businessPolicyScopeDtoList)) {
            businessPolicyScopeDtoList.forEach(item -> {
                item.setBusinessPolicyCode(code);
                item.setTenantCode(TenantUtils.getTenantCode());
                item.setId(null);
            });
            Collection<BusinessPolicyScope> businessPolicyScopes = this.nebulaToolkitService.copyCollectionByBlankList(businessPolicyScopeDtoList, BusinessPolicyScopeDto.class, BusinessPolicyScope.class, LinkedHashSet.class, ArrayList.class);
            this.businessPolicyScopeRepository.saveBatch(businessPolicyScopes);

        }

        if (SaveTypeEnum.SUBMIT.getCode().equals(businessPolicy.getSaveType())) {
            //提交工作流
            this.submitApproval(businessPolicy);
        }

        //新增业务日志
        BusinessPolicyLogEventDto logEventDto = new BusinessPolicyLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(businessPolicy);
        SerializableBiConsumer<BusinessPolicyEventListener, BusinessPolicyLogEventDto> onCreate =
                BusinessPolicyEventListener::onCreate;
        this.nebulaNetEventClient.publish(logEventDto, BusinessPolicyEventListener.class, onCreate);
    }

    /**
     * 修改新据
     *
     * @param businessPolicy 实体对象
     * @return 修改结果
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void update(BusinessPolicyDto businessPolicy) {
        this.updateValidate(businessPolicy);
        BusinessPolicyVo oldVo = this.findById(businessPolicy.getId());
        //审批中或审批通过的数据不允许删除
        Validate.isTrue(!ProcessStatusEnum.PASS.getDictCode().equals(oldVo.getProcessStatus()) &&
                !ProcessStatusEnum.COMMIT.getDictCode().equals(oldVo.getProcessStatus()), "审批中或审批通过的数据不允许修改");
        businessPolicy.setTenantCode(TenantUtils.getTenantCode());
        BusinessPolicy businessPolicyEntity = this.nebulaToolkitService.copyObjectByWhiteList(businessPolicy, BusinessPolicy.class, null, null);
        this.businessPolicyRepository.updateById(businessPolicyEntity);
        //预算
        this.businessPolicyBudgetRepository.remove(Wrappers.lambdaUpdate(BusinessPolicyBudget.class).eq(BusinessPolicyBudget::getBusinessPolicyCode, businessPolicyEntity.getBusinessPolicyCode()));
        //预算
        List<BusinessPolicyBudgetDto> businessPolicyBudgetDtoList = businessPolicy.getBusinessPolicyBudgetDtoList();
        if (!CollectionUtils.isEmpty(businessPolicyBudgetDtoList)) {
            businessPolicyBudgetDtoList.forEach(item -> {
                item.setId(null);
                item.setBusinessPolicyCode(businessPolicyEntity.getBusinessPolicyCode());
                item.setTenantCode(TenantUtils.getTenantCode());
                //费用率(%)：自动计算，费用率（%）=申请金额/预估销售额*100，保留6位小数
                item.setFeeRatio(item.getApplyAmount().divide(item.getEstimateSaleAmount(), 6, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100)));
            });
            Collection<BusinessPolicyBudget> businessPolicyBudgets = this.nebulaToolkitService.copyCollectionByBlankList(businessPolicyBudgetDtoList, BusinessPolicyBudgetDto.class, BusinessPolicyBudget.class, LinkedHashSet.class, ArrayList.class);
            businessPolicyBudgetRepository.saveBatch(businessPolicyBudgets);
        }
        //产品
        this.businessPolicyProductRepository.remove(Wrappers.lambdaUpdate(BusinessPolicyProduct.class).eq(BusinessPolicyProduct::getBusinessPolicyCode, businessPolicyEntity.getBusinessPolicyCode()));
//        List<BusinessPolicyProductDto> businessPolicyProductDtoList = businessPolicy.getBusinessPolicyProductDtoList();
        List<BusinessPolicyProductDto> businessPolicyProductDtoList = businessPolicyProductService.findCacheList(businessPolicy.getCacheKey());
        if (!CollectionUtils.isEmpty(businessPolicyProductDtoList)) {
            businessPolicyProductDtoList.forEach(item -> {
                item.setId(null);
                item.setBusinessPolicyCode(businessPolicyEntity.getBusinessPolicyCode());
                item.setTenantCode(TenantUtils.getTenantCode());
            });
            Collection<BusinessPolicyProduct> businessPolicyProducts = this.nebulaToolkitService.copyCollectionByBlankList(businessPolicyProductDtoList, BusinessPolicyProductDto.class, BusinessPolicyProduct.class, LinkedHashSet.class, ArrayList.class);
            businessPolicyProductRepository.saveBatch(businessPolicyProducts);
        }
        //范围
        this.businessPolicyScopeRepository.remove(Wrappers.lambdaUpdate(BusinessPolicyScope.class).eq(BusinessPolicyScope::getBusinessPolicyCode, businessPolicyEntity.getBusinessPolicyCode()));
        List<BusinessPolicyScopeDto> businessPolicyScopeDtoList = businessPolicy.getBusinessPolicyScopeDtoList();
        if (!CollectionUtils.isEmpty(businessPolicyScopeDtoList)) {
            businessPolicyScopeDtoList.forEach(item -> {
                item.setId(null);
                item.setBusinessPolicyCode(businessPolicyEntity.getBusinessPolicyCode());
                item.setTenantCode(TenantUtils.getTenantCode());
            });
            Collection<BusinessPolicyScope> businessPolicyScopes = this.nebulaToolkitService.copyCollectionByBlankList(businessPolicyScopeDtoList, BusinessPolicyScopeDto.class, BusinessPolicyScope.class, LinkedHashSet.class, ArrayList.class);
            this.businessPolicyScopeRepository.saveBatch(businessPolicyScopes);
        }

        if (SaveTypeEnum.SUBMIT.getCode().equals(businessPolicy.getSaveType())) {
            //提交工作流
            this.submitApproval(businessPolicy);
        }

        //更新业务日志
        BusinessPolicyLogEventDto logEventDto = new BusinessPolicyLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(businessPolicy);
        SerializableBiConsumer<BusinessPolicyEventListener, BusinessPolicyLogEventDto> onUpdate =
                BusinessPolicyEventListener::onUpdate;
        this.nebulaNetEventClient.publish(logEventDto, BusinessPolicyEventListener.class, onUpdate);
    }

    /**
     * 删除数据
     *
     * @param idList 主键结合
     * @return 删除结果
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void delete(List<String> idList) {
        Validate.isTrue(!CollectionUtils.isEmpty(idList), "删除数据时，主键集合不能为空！");
        List<BusinessPolicy> businessPolicyList1 = this.businessPolicyRepository.listByIds(idList);
        Validate.isTrue(!CollectionUtils.isEmpty(businessPolicyList1), "要删除的数据不能为空");
        //循环校验数据审批状态，审批中或审批通过的数据不允许删除
        for (BusinessPolicy businessPolicy : businessPolicyList1) {
            Validate.isTrue(!ProcessStatusEnum.PASS.getDictCode().equals(businessPolicy.getProcessStatus()) &&
                    !ProcessStatusEnum.COMMIT.getDictCode().equals(businessPolicy.getProcessStatus()), "审批中或审批通过的数据不允许删除");
        }
        List<BusinessPolicy> businessPolicyList = new ArrayList<>();
        businessPolicyList1.forEach(item -> {
            BusinessPolicy businessPolicy = new BusinessPolicy();
            businessPolicy.setId(item.getId());
            businessPolicy.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            businessPolicyList.add(businessPolicy);

            //删除业务日志
            BusinessPolicyLogEventDto logEventDto = new BusinessPolicyLogEventDto();
            BusinessPolicyVo oldVo = this.nebulaToolkitService.copyObjectByWhiteList(item, BusinessPolicyVo.class, null, null);
            logEventDto.setOriginal(oldVo);
            BusinessPolicyDto businessPolicyDto = this.nebulaToolkitService.copyObjectByWhiteList(item, BusinessPolicyDto.class, null, null);
            businessPolicyDto.setDelFlag(businessPolicy.getDelFlag());
            logEventDto.setNewest(businessPolicyDto);
            SerializableBiConsumer<BusinessPolicyEventListener, BusinessPolicyLogEventDto> onDelete =
                    BusinessPolicyEventListener::onDelete;
            this.nebulaNetEventClient.publish(logEventDto, BusinessPolicyEventListener.class, onDelete);
        });
        this.businessPolicyRepository.updateBatchById(businessPolicyList);
    }

    @Override
    public void close(List<String> idList) {
        Validate.isTrue(!CollectionUtils.isEmpty(idList), "删除数据时，主键集合不能为空！");
        List<BusinessPolicy> businessPolicyList1 = this.businessPolicyRepository.listByIds(idList);
        Validate.isTrue(!CollectionUtils.isEmpty(idList), "删除数据时，主键集合不能为空！");
        List<BusinessPolicy> collect = businessPolicyList1.stream().filter(x -> !x.getProcessStatus().equals(ProcessStatusEnum.PASS.getDictCode())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collect)) {
            throw new IllegalArgumentException("数据集中存在非审批通过的数据，请检查");
        }
        List<String> codeList = businessPolicyList1.stream().map(e -> e.getBusinessPolicyCode()).collect(Collectors.toList());
        List<GeneralExpensesVo> generalExpensesVoList = generalExpensesService.findByBusinessPolicyCode(codeList);
        if (!CollectionUtils.isEmpty(generalExpensesVoList)) {
            throw new IllegalArgumentException("商务政策【" + generalExpensesVoList.get(0).getCommercePolicyCode() + "】在促销规划【" + generalExpensesVoList.get(0).getPromotionPlanCode() + "】中被使用，不允许关闭");
        }
        List<BusinessPolicy> businessPolicyList = new ArrayList<>();
        businessPolicyList1.forEach(item -> {
            BusinessPolicy businessPolicy = new BusinessPolicy();
            businessPolicy.setId(item.getId());
            businessPolicy.setProcessStatus(ProcessStatusEnum.COLSE.getDictCode());
            businessPolicyList.add(businessPolicy);

            //关闭业务日志
            BusinessPolicyLogEventDto logEventDto = new BusinessPolicyLogEventDto();
            BusinessPolicyVo oldVo = this.nebulaToolkitService.copyObjectByWhiteList(item, BusinessPolicyVo.class, null, null);
            logEventDto.setOriginal(oldVo);
            BusinessPolicyDto businessPolicyDto = this.nebulaToolkitService.copyObjectByWhiteList(item, BusinessPolicyDto.class, null, null);
            businessPolicyDto.setProcessStatus(businessPolicy.getProcessStatus());
            logEventDto.setNewest(businessPolicyDto);
            SerializableBiConsumer<BusinessPolicyEventListener, BusinessPolicyLogEventDto> onClose =
                    BusinessPolicyEventListener::onClose;
            this.nebulaNetEventClient.publish(logEventDto, BusinessPolicyEventListener.class, onClose);
        });
        this.businessPolicyRepository.updateBatchById(businessPolicyList);
    }

    @Override
    public void batchSubmitApproval(BusinessPolicyApprovalDto dto) {
        List<String> ids = dto.getIds();
        Validate.isTrue(!CollectionUtils.isEmpty(ids), "提交审批流的id不能为空");
        for (String id : ids) {
            BusinessPolicy businessPolicy = this.businessPolicyRepository.getById(id);
            Validate.notNull(businessPolicy, "未找到id为【%s】的核销数据");
            Validate.isTrue(ProcessStatusEnum.PREPARE.getDictCode().equals(businessPolicy.getProcessStatus())
                    || ProcessStatusEnum.REJECT.getDictCode().equals(businessPolicy.getProcessStatus())
                    || ProcessStatusEnum.RECOVER.getDictCode().equals(businessPolicy.getProcessStatus()), "只能提交处于驳回，追回，待提交状态的核销申请");
            BusinessPolicyDto auditDto = this.nebulaToolkitService.copyObjectByWhiteList(businessPolicy, BusinessPolicyDto.class, null, null);
            auditDto.setProcessBusiness(dto.getProcessBusiness());
            this.submitApproval(auditDto);
        }
    }

    /**
     * 编码查询
     *
     * @param codes
     */
    @Override
    public List<BusinessPolicyVo> findBusinessPolicyByCode(Set<String> codes) {
        Validate.isTrue(!CollectionUtils.isEmpty(codes), "查询的编码不能为空");
        List<BusinessPolicy> list = businessPolicyRepository.lambdaQuery().in(BusinessPolicy::getBusinessPolicyCode, codes)
                .eq(BusinessPolicy::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(BusinessPolicy::getProcessStatus, ProcessStatusEnum.PASS.getDictCode()).list();
        return CollectionUtils.isEmpty(list) ? new ArrayList<>() :
                new ArrayList<>(nebulaToolkitService.copyCollectionByWhiteList(list, BusinessPolicy.class, BusinessPolicyVo.class, HashSet.class, ArrayList.class));
    }

    /**
     * 申请金额修改
     *
     * @param voList
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateBusinessPolicyApplyAmount(List<BusinessPolicyVo> voList) {
        Validate.isTrue(!CollectionUtils.isEmpty(voList), "修改的促销政策不能为空");
        businessPolicyRepository.updateBusinessPolicyApplyAmount(voList);
    }

    @Override
    public void returnBudget(BusinessPolicyDto businessPolicyDto) {
        List<BusinessPolicyBudget> list = this.businessPolicyBudgetRepository.lambdaQuery().eq(BusinessPolicyBudget::getBusinessPolicyCode, businessPolicyDto.getBusinessPolicyCode()).list();
        if (!CollectionUtils.isEmpty(list)) {
            //预算编码
            Set<String> budgetCodeSet = list.stream().map(BusinessPolicyBudget::getBudgetCode).collect(Collectors.toSet());
            try {
                Validate.isTrue(monthBudgetLockService.lock(new ArrayList<>(budgetCodeSet), TimeUnit.SECONDS, BudgetLockConstant.DEFAULT_LOCK_TIME), "预算加锁失败，请稍后重试");

                List<PromotionOperateMonthBudgetDto> dtoList = new ArrayList<>();
                for (BusinessPolicyBudget businessPolicyBudget : list) {
                    PromotionOperateMonthBudgetDto operateMonthBudgetDto = new PromotionOperateMonthBudgetDto();
                    operateMonthBudgetDto.setMonthBudgetCode(businessPolicyBudget.getBudgetCode());
                    operateMonthBudgetDto.setOperationAmount(businessPolicyBudget.getApplyAmount());
                    operateMonthBudgetDto.setBudgetType(MonthBudgetTypeEnum.MONTH_BUDGET.getCode());
                    operateMonthBudgetDto.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                    operateMonthBudgetDto.setFeeRatio(businessPolicyBudget.getFeeRatio());
                    operateMonthBudgetDto.setBusinessCode(businessPolicyBudget.getBusinessPolicyCode());
                    dtoList.add(operateMonthBudgetDto);
                }
                monthBudgetService.operatePromotionBudget(dtoList);
            } finally {
                monthBudgetLockService.unLock(new ArrayList<>(budgetCodeSet));
            }

        }
    }

    /**
     * 查询预算
     *
     * @param code
     * @return
     */
    @Override
    public List<BusinessPolicyBudgetVo> findBusinessPolicyBudget(String code) {
        List<BusinessPolicyBudget> list = this.businessPolicyBudgetRepository.lambdaQuery().eq(BusinessPolicyBudget::getBusinessPolicyCode, code).list();
        return CollectionUtils.isEmpty(list) ? new ArrayList<>() : new ArrayList<>(this.nebulaToolkitService.copyCollectionByBlankList(list, BusinessPolicyBudget.class, BusinessPolicyBudgetVo.class, LinkedHashSet.class, ArrayList.class));
    }

    @Override
    public List<BusinessPolicyVo> findWholeAuditBusinessPolicyBudget(List<String> codes) {
        List<BusinessPolicy> list = this.businessPolicyRepository.lambdaQuery()
                .in(BusinessPolicy::getBusinessPolicyCode, codes).list();

        List<BusinessPolicyVo> businessPolicyVos = new ArrayList<>();
        if (!CollectionUtils.isEmpty(list)) {
            List<BusinessPolicyBudget> list1 = this.businessPolicyBudgetRepository.lambdaQuery().in(BusinessPolicyBudget::getBusinessPolicyCode, codes).list();
            Map<String, List<BusinessPolicyBudget>> businessPolicyBudgetMap = list1.stream().collect(Collectors.groupingBy(BusinessPolicyBudget::getBusinessPolicyCode));
            for (BusinessPolicy businessPolicy : list) {
                BusinessPolicyVo businessPolicyVo = this.nebulaToolkitService.copyObjectByBlankList(businessPolicy, BusinessPolicyVo.class, null, null);
                List<BusinessPolicyBudget> businessPolicyBudgets = businessPolicyBudgetMap.get(businessPolicyVo.getBusinessPolicyCode());
                if (!CollectionUtils.isEmpty(businessPolicyBudgets)) {
                    businessPolicyVo.setBusinessPolicyBudgetVoList((List<BusinessPolicyBudgetVo>) this.nebulaToolkitService.copyCollectionByBlankList(businessPolicyBudgets, BusinessPolicyBudget.class, BusinessPolicyBudgetVo.class, LinkedHashSet.class, ArrayList.class));
                }
                businessPolicyVos.add(businessPolicyVo);
            }
        }
        return businessPolicyVos;

    }

    @Override
    public void updateBusinessPolicyByAuditPass(List<BusinessPolicyDto> businessPolicyDtoList) {
        businessPolicyRepository.updateBusinessPolicyByAuditPass(businessPolicyDtoList);
    }

    private ProcessBusinessVo submitApproval(BusinessPolicyDto dto) {
        Validate.notNull(dto, "提交审批流的数据不能为空");
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();

        //占用预算
        useBudget(dto);
        //先改成id，让流程能进行下去
        processBusiness.setBusinessNo(dto.getId());
        JSONObject jsonObject = JsonUtils.toJSONObject(dto);

        processBusiness.setBusinessFormJson(jsonObject.toJSONString());
        processBusiness.setBusinessCode(BusinessPolicyConstants.ORDINARY_BUSINESS_POLICY_PROCESS);
        ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(processBusiness);

        BusinessPolicy businessPolicy = new BusinessPolicy();
        businessPolicy.setId(dto.getId());
        businessPolicy.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
        businessPolicy.setProcessNo(processBusinessVo.getProcessNo());
        this.businessPolicyRepository.updateById(businessPolicy);
        return processBusinessVo;
    }

    private void useBudget(BusinessPolicyDto dto) {

        List<BusinessPolicyBudget> list = this.businessPolicyBudgetRepository.lambdaQuery().eq(BusinessPolicyBudget::getBusinessPolicyCode, dto.getBusinessPolicyCode()).list();
        if (!CollectionUtils.isEmpty(list)) {
            //预算编码
            Set<String> budgetCodeSet = list.stream().map(BusinessPolicyBudget::getBudgetCode).collect(Collectors.toSet());
            try {
                Validate.isTrue(monthBudgetLockService.lock(new ArrayList<>(budgetCodeSet), TimeUnit.SECONDS, BudgetLockConstant.DEFAULT_LOCK_TIME), "预算加锁失败，请稍后重试");

                List<PromotionOperateMonthBudgetDto> dtoList = new ArrayList<>();
                for (BusinessPolicyBudget businessPolicyBudget : list) {
                    PromotionOperateMonthBudgetDto operateMonthBudgetDto = new PromotionOperateMonthBudgetDto();
                    operateMonthBudgetDto.setMonthBudgetCode(businessPolicyBudget.getBudgetCode());
                    operateMonthBudgetDto.setOperationAmount(businessPolicyBudget.getApplyAmount());
                    operateMonthBudgetDto.setBudgetType(MonthBudgetTypeEnum.MONTH_BUDGET.getCode());
                    operateMonthBudgetDto.setOperationType(BudgetOperationTypeEnum.USE.getCode());
                    operateMonthBudgetDto.setFeeRatio(businessPolicyBudget.getFeeRatio());
                    operateMonthBudgetDto.setBusinessCode(businessPolicyBudget.getBusinessPolicyCode());
                    dtoList.add(operateMonthBudgetDto);
                }
                monthBudgetService.operatePromotionBudget(dtoList);
            } finally {
                monthBudgetLockService.unLock(new ArrayList<>(budgetCodeSet));
            }

        }
    }

    /**
     * 创建验证
     *
     * @param businessPolicy
     */
    private void createValidate(BusinessPolicyDto businessPolicy) {
        Validate.notNull(businessPolicy, "新增时，对象信息不能为空！");
        businessPolicy.setId(null);
        Validate.notBlank(businessPolicy.getCacheKey(), "缓存key不能为空");
        Validate.notBlank(businessPolicy.getBusinessPolicyName(), "商务政策名称不能为空");
        Validate.notNull(businessPolicy.getApplyAmount(), "申请金额不能为空");
        Validate.notNull(businessPolicy.getPolicyBeginTime(), "政策开始时间不能为空");
        Validate.notNull(businessPolicy.getPolicyEndTime(), "政策结束时间不能为空");
        Validate.isTrue(!CollectionUtils.isEmpty(businessPolicy.getBusinessPolicyBudgetDtoList()), "预算信息不能为空");
        businessPolicy.getBusinessPolicyBudgetDtoList().forEach(item -> {
            item.setId(null);
            Validate.isTrue(Objects.nonNull(item.getApplyAmount()), "申请金额不能为空");
            Validate.isTrue(Objects.nonNull(item.getEstimateSaleAmount()), "预估销售额不能为空");
            Validate.isTrue(item.getEstimateSaleAmount().compareTo(BigDecimal.ZERO) > 0, "预估销售额必须大于0");
        });
//        Validate.isTrue(!CollectionUtils.isEmpty(businessPolicy.getBusinessPolicyProductDtoList()), "考核产品不能为空");
//        businessPolicy.getBusinessPolicyProductDtoList().forEach(item -> {
//            item.setId(null);
//        });
        Validate.isTrue(!CollectionUtils.isEmpty(businessPolicy.getBusinessPolicyScopeDtoList()), "政策范围不能为空");
        businessPolicy.getBusinessPolicyScopeDtoList().forEach(item -> {
            item.setId(null);
        });

    }

    /**
     * 修改验证
     *
     * @param businessPolicy
     */
    private void updateValidate(BusinessPolicyDto businessPolicy) {
        Validate.notNull(businessPolicy, "修改时，对象信息不能为空！");
        Validate.notBlank(businessPolicy.getCacheKey(), "缓存key不能为空");
        Validate.notBlank(businessPolicy.getId(), "修改数据时，不能为空！");
//    Validate.notBlank(businessPolicy.getTenantCode(), "新增数据时，租户编号不能为空！");
        Validate.notBlank(businessPolicy.getId(), "id不能为空");
        Validate.notBlank(businessPolicy.getBusinessPolicyName(), "商务政策名称不能为空");
        Validate.notNull(businessPolicy.getApplyAmount(), "申请金额不能为空");
        Validate.notNull(businessPolicy.getPolicyBeginTime(), "政策开始时间不能为空");
        Validate.notNull(businessPolicy.getPolicyEndTime(), "政策结束时间不能为空");
        Validate.isTrue(!CollectionUtils.isEmpty(businessPolicy.getBusinessPolicyBudgetDtoList()), "预算信息不能为空");
        businessPolicy.getBusinessPolicyBudgetDtoList().forEach(item -> {
            item.setId(null);
            Validate.isTrue(Objects.nonNull(item.getApplyAmount()), "申请金额不能为空");
            Validate.isTrue(Objects.nonNull(item.getEstimateSaleAmount()), "预估销售额不能为空");
            Validate.isTrue(item.getEstimateSaleAmount().compareTo(BigDecimal.ZERO) > 0, "预估销售额必须大于0");
        });
//        Validate.isTrue(!CollectionUtils.isEmpty(businessPolicy.getBusinessPolicyProductDtoList()), "考核产品不能为空");
//        businessPolicy.getBusinessPolicyProductDtoList().forEach(item -> {
//            item.setId(null);
//        });
        Validate.isTrue(!CollectionUtils.isEmpty(businessPolicy.getBusinessPolicyScopeDtoList()), "政策范围不能为空");
        businessPolicy.getBusinessPolicyScopeDtoList().forEach(item -> {
            item.setId(null);
        });

        BusinessPolicy one = this.businessPolicyRepository.getById(businessPolicy.getId());
        Validate.isTrue(ProcessStatusEnum.PREPARE.getDictCode().equals(one.getProcessStatus())
                || ProcessStatusEnum.REJECT.getDictCode().equals(one.getProcessStatus())
                || ProcessStatusEnum.RECOVER.getDictCode().equals(one.getProcessStatus()), "只能提交处于驳回，追回，待提交状态的核销申请");
    }

}

