package com.biz.crm.tpm.business.business.policy.local.workFlowListener;

import com.biz.crm.tpm.business.business.policy.local.constants.BusinessPolicyConstants;
import com.biz.crm.tpm.business.business.policy.local.entity.BusinessPolicy;
import com.biz.crm.tpm.business.business.policy.local.repository.BusinessPolicyRepository;
import com.biz.crm.tpm.business.business.policy.sdk.dto.BusinessPolicyDto;
import com.biz.crm.tpm.business.business.policy.sdk.service.BusinessPolicyService;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;


/**
 * @author ：dengwei
 * @date ：Created in 2022/11/10 17:00
 * @description：商务政策审批回调
 */
@Component
@Slf4j
public class OrdinaryBusinessPolicyProcessCallBackListener implements ProcessCompleteListener {

    @Autowired(required = false)
    private BusinessPolicyRepository businessPolicyRepository;

    @Autowired(required = false)
    private BusinessPolicyService businessPolicyService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public String getBusinessCode() {
        return BusinessPolicyConstants.ORDINARY_BUSINESS_POLICY_PROCESS;
    }

    @Override
    public void onProcessComplete(ProcessStatusDto dto) {

        String processStatus = dto.getProcessStatus();

        BusinessPolicy one = this.businessPolicyRepository.getById(dto.getBusinessNo());
        //校验回调实例
        Validate.notNull(one, "商务政策审批流程回调失败，未查询到当前实例");
        BusinessPolicy audit = new BusinessPolicy();
        audit.setId(one.getId());
        //审批通过
        if (String.valueOf(processStatus).equals(ProcessStatusEnum.PASS.getDictCode())) {
            audit.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
            this.businessPolicyRepository.updateById(audit);
            log.info("商务政策审批通过，审批状态：{}",processStatus);

        }
        //审批驳回
        if (String.valueOf(processStatus).equals(ProcessStatusEnum.REJECT.getDictCode())) {
            audit.setProcessStatus(ProcessStatusEnum.REJECT.getDictCode());
            this.businessPolicyRepository.updateById(audit);
            returnBudget(one);
        }
        //流程追回
        if (String.valueOf(processStatus).equals(ProcessStatusEnum.RECOVER.getDictCode())) {
            audit.setProcessStatus(ProcessStatusEnum.RECOVER.getDictCode());
            this.businessPolicyRepository.updateById(audit);
            returnBudget(one);
        }
    }

    private void returnBudget(BusinessPolicy one) {

        BusinessPolicyDto businessPolicyDto = this.nebulaToolkitService.copyObjectByWhiteList(one, BusinessPolicyDto.class, null, null);
        businessPolicyService.returnBudget(businessPolicyDto);
    }
}
