/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.business.policy.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.business.policy.local.imports.PolicyProductImportsProcess;
import com.biz.crm.tpm.business.business.policy.local.imports.vo.PolicyProductImportVo;
import com.biz.crm.tpm.business.business.policy.sdk.dto.BusinessPolicyApprovalDto;
import com.biz.crm.tpm.business.business.policy.sdk.dto.BusinessPolicyDto;
import com.biz.crm.tpm.business.business.policy.sdk.service.BusinessPolicyService;
import com.biz.crm.tpm.business.business.policy.sdk.vo.BusinessPolicyVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/businessPolicy"})
@Api(tags={"\u5546\u52a1\u653f\u7b56\u4e3b\u8868"})
public class BusinessPolicyController {
    private static final Logger log = LoggerFactory.getLogger(BusinessPolicyController.class);
    @Autowired(required=false)
    private BusinessPolicyService businessPolicyService;
    @Autowired(required=false)
    private PolicyProductImportsProcess policyProductImportsProcess;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<BusinessPolicyVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="businessPolicy", value="\u5546\u52a1\u653f\u7b56\u4e3b\u8868") BusinessPolicyDto businessPolicy) {
        try {
            Page page = this.businessPolicyService.findByConditions(pageable, businessPolicy);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"{id}"})
    public Result<BusinessPolicyVo> findById(@PathVariable @ApiParam(name="id", value="\u4e3b\u952eid") String id) {
        try {
            BusinessPolicyVo businessPolicy = this.businessPolicyService.findById(id);
            return Result.ok((Object)businessPolicy);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping
    public Result<?> create(@ApiParam(name="businessPolicy", value="\u5546\u52a1\u653f\u7b56\u4e3b\u8868") @RequestBody BusinessPolicyDto businessPolicy) {
        try {
            this.businessPolicyService.create(businessPolicy);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @PatchMapping
    public Result<?> update(@ApiParam(name="businessPolicy", value="\u5546\u52a1\u653f\u7b56\u4e3b\u8868") @RequestBody BusinessPolicyDto businessPolicy) {
        try {
            this.businessPolicyService.update(businessPolicy);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @DeleteMapping(value={"delete"})
    public Result<?> delete(@ApiParam(name="idList", value="\u4e3b\u952e\u96c6\u5408") @RequestParam(value="ids") List<String> ids) {
        try {
            this.businessPolicyService.delete(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"close"})
    public Result<?> close(@RequestBody List<String> idList) {
        try {
            this.businessPolicyService.close(idList);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"batchSubmitApproval"})
    public Result<?> batchSubmitApproval(@RequestBody BusinessPolicyApprovalDto dto) {
        try {
            this.businessPolicyService.batchSubmitApproval(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"findActivityFormByCode"})
    public Result<List<BusinessPolicyVo>> findBusinessPolicyByCode(@RequestBody Set<String> businessPolicyCodes) {
        try {
            return Result.ok((Object)this.businessPolicyService.findBusinessPolicyByCode(businessPolicyCodes));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"updateBusinessPolicyApplyAmount"})
    public Result<?> updateBusinessPolicyApplyAmount(@RequestBody List<BusinessPolicyVo> voList) {
        try {
            this.businessPolicyService.updateBusinessPolicyApplyAmount(voList);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"testImport"})
    public Result<?> testImport() {
        LinkedHashMap<Integer, PolicyProductImportVo> data = new LinkedHashMap<Integer, PolicyProductImportVo>();
        PolicyProductImportVo policyProductImportVo = new PolicyProductImportVo();
        policyProductImportVo.setProductCode("130100001564");
        policyProductImportVo.setProductName("aaa");
        data.put(1, policyProductImportVo);
        PolicyProductImportVo policyProductImportVo2 = new PolicyProductImportVo();
        policyProductImportVo2.setProductCode("130100002240");
        policyProductImportVo2.setProductName("aaa");
        data.put(2, policyProductImportVo2);
        PolicyProductImportVo policyProductImportVo3 = new PolicyProductImportVo();
        policyProductImportVo3.setProductCode("130100002673");
        policyProductImportVo3.setProductName("aaa");
        data.put(3, policyProductImportVo3);
        PolicyProductImportVo policyProductImportVo4 = new PolicyProductImportVo();
        policyProductImportVo4.setProductCode("130100001828");
        policyProductImportVo4.setProductName("aaa");
        data.put(4, policyProductImportVo4);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("cacheKey", "AAAAAAAAAAAAAAAA");
        this.policyProductImportsProcess.execute(data, null, params);
        return Result.ok();
    }
}

