/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.business.policy.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.business.policy.local.entity.BusinessPolicyScope;
import com.biz.crm.tpm.business.business.policy.local.exports.BusinessPolicyScopeExportProcess;
import com.biz.crm.tpm.business.business.policy.local.imports.BusinessPolicyScopeImportProcess;
import com.biz.crm.tpm.business.business.policy.local.service.BusinessPolicyScopeService;
import com.biz.crm.tpm.business.business.policy.sdk.dto.BusinessPolicyScopeDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/businessPolicyScope"})
@Api(tags={"\u653f\u7b56\u8303\u56f4"})
public class BusinessPolicyScopeController {
    private static final Logger log = LoggerFactory.getLogger(BusinessPolicyScopeController.class);
    @Autowired
    private BusinessPolicyScopeService businessPolicyScopeService;
    @Autowired(required=false)
    private BusinessPolicyScopeExportProcess businessPolicyScopeExportProcess;
    @Autowired(required=false)
    private BusinessPolicyScopeImportProcess businessPolicyScopeImportProcess;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<BusinessPolicyScope>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="businessPolicyScope", value="\u653f\u7b56\u8303\u56f4") BusinessPolicyScope businessPolicyScope) {
        try {
            Page<BusinessPolicyScope> page = this.businessPolicyScopeService.findByConditions(pageable, businessPolicyScope);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"{id}"})
    public Result<BusinessPolicyScope> findById(@PathVariable @ApiParam(name="id", value="\u4e3b\u952eid") String id) {
        try {
            BusinessPolicyScope businessPolicyScope = this.businessPolicyScopeService.findById(id);
            return Result.ok((Object)((Object)businessPolicyScope));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping
    public Result<BusinessPolicyScope> create(@ApiParam(name="businessPolicyScope", value="\u653f\u7b56\u8303\u56f4") @RequestBody BusinessPolicyScope businessPolicyScope) {
        try {
            BusinessPolicyScope result = this.businessPolicyScopeService.create(businessPolicyScope);
            return Result.ok((Object)((Object)result));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @PatchMapping
    public Result<BusinessPolicyScope> update(@ApiParam(name="businessPolicyScope", value="\u653f\u7b56\u8303\u56f4") @RequestBody BusinessPolicyScope businessPolicyScope) {
        try {
            BusinessPolicyScope result = this.businessPolicyScopeService.update(businessPolicyScope);
            return Result.ok((Object)((Object)result));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @DeleteMapping
    public Result<?> delete(@ApiParam(name="idList", value="\u4e3b\u952e\u96c6\u5408") @RequestParam(value="idList") List<String> idList) {
        try {
            this.businessPolicyScopeService.delete(idList);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"saveScopeExports"})
    public Result<?> saveScopeExports(@RequestBody List<BusinessPolicyScopeDto> dtos) {
        try {
            return Result.ok((String)this.businessPolicyScopeExportProcess.saveScopeExports(dtos));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"getPolicyScope"})
    public Result<List<BusinessPolicyScopeDto>> getPolicyScope(@RequestParam(value="cacheKey") String cacheKey) {
        try {
            return Result.ok(this.businessPolicyScopeImportProcess.getPolicyScope(cacheKey));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

