/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.business.policy.local.exports;

import com.alibaba.fastjson.JSONArray;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import com.biz.crm.tpm.business.business.policy.local.exports.vo.BusinessPolicyScopeExportVo;
import com.biz.crm.tpm.business.business.policy.sdk.dto.BusinessPolicyScopeDto;
import com.bizunited.nebula.common.util.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BusinessPolicyScopeExportProcess
implements ExportProcess<BusinessPolicyScopeExportVo> {
    @Autowired(required=false)
    private RedisService redisService;

    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    public Integer getTotal(Map<String, Object> params) {
        String cacheKey = this.getFromCacheKey(params);
        Object o = this.redisService.get(cacheKey);
        if (Objects.isNull(o)) {
            return 0;
        }
        List list = (List)JsonUtils.json2Obj((String)((String)o), (TypeReference)new TypeReference<List<BusinessPolicyScopeExportVo>>(){});
        if (CollectionUtils.isEmpty((Collection)list)) {
            return 0;
        }
        Integer total = list.size();
        Validate.isTrue((total < CommonConstant.IE_EXPORT_MAX_TOTAL ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"), (Object[])new Object[0]);
        return total;
    }

    private String getFromCacheKey(Map<String, Object> params) {
        String cacheKey = (String)params.get("cacheKey");
        Validate.isTrue((!StringUtils.isEmpty((CharSequence)cacheKey) ? 1 : 0) != 0, (String)"\u7f13\u5b58key\u4e0d\u80fd\u7a7a", (Object[])new Object[0]);
        return "business_policy:scope:" + cacheKey;
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        String cacheKey = this.getFromCacheKey(params);
        Object o = this.redisService.get(cacheKey);
        if (Objects.isNull(o)) {
            return new JSONArray();
        }
        return JSONArray.parseArray((String)((String)o));
    }

    public String saveScopeExports(List<BusinessPolicyScopeDto> dtos) {
        Validate.isTrue((!CollectionUtils.isEmpty(dtos) ? 1 : 0) != 0, (String)"\u4fdd\u5b58\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String cacheKey = UuidCrmUtil.randomUuid();
        this.redisService.set("business_policy:scope:" + cacheKey, (Object)JsonUtils.obj2JsonString(dtos), 300L);
        return cacheKey;
    }

    public String getBusinessCode() {
        return "business_policy_scope_export_process";
    }

    public String getBusinessName() {
        return "\u4fc3\u9500\u653f\u7b56\u8303\u56f4\u5bfc\u51fa";
    }
}

