/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.business.policy.local.exports;

import com.alibaba.fastjson.JSONArray;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.business.policy.local.exports.vo.PolicyProductExportVo;
import com.biz.crm.tpm.business.business.policy.local.service.BusinessPolicyProductService;
import com.bizunited.nebula.common.util.JsonUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class PolicyProductExportsProcess
implements ExportProcess<PolicyProductExportVo> {
    @Autowired(required=false)
    private BusinessPolicyProductService businessPolicyProductService;

    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    public Integer getTotal(Map<String, Object> params) {
        String cacheKey = this.getFromCacheKey(params);
        List cacheList = this.businessPolicyProductService.findCacheList(cacheKey);
        if (CollectionUtils.isEmpty((Collection)cacheList)) {
            return 0;
        }
        Integer total = cacheList.size();
        Validate.isTrue((total < CommonConstant.IE_EXPORT_MAX_TOTAL ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"), (Object[])new Object[0]);
        return total;
    }

    private String getFromCacheKey(Map<String, Object> params) {
        String cacheKey = (String)params.get("cacheKey");
        Validate.isTrue((!StringUtils.isEmpty((CharSequence)cacheKey) ? 1 : 0) != 0, (String)"\u7f13\u5b58key\u4e0d\u80fd\u7a7a", (Object[])new Object[0]);
        return cacheKey;
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        String cacheKey = this.getFromCacheKey(params);
        List cacheList = this.businessPolicyProductService.findCacheList(cacheKey);
        String s = JsonUtils.obj2JsonString((Object)cacheList);
        return JSONArray.parseArray((String)s);
    }

    public String getBusinessCode() {
        return "policy_product_exports_process";
    }

    public String getBusinessName() {
        return "\u4fc3\u9500\u653f\u7b56\u4ea7\u54c1\u5bfc\u51fa";
    }
}

