/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.business.policy.local.helper;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.business.policy.local.repository.BusinessPolicyProductRepository;
import com.biz.crm.tpm.business.business.policy.sdk.dto.BusinessPolicyProductDto;
import com.biz.crm.tpm.business.business.policy.sdk.vo.BusinessPolicyProductVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BusinessPolicyProductHelper
extends MnPageCacheHelper<BusinessPolicyProductVo, BusinessPolicyProductDto> {
    @Autowired(required=false)
    private BusinessPolicyProductRepository businessPolicyProductRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public String getCacheKeyPrefix() {
        return "business_policy_product_cache_key_prefix:";
    }

    public Class<BusinessPolicyProductDto> getDtoClass() {
        return BusinessPolicyProductDto.class;
    }

    public Class<BusinessPolicyProductVo> getVoClass() {
        return BusinessPolicyProductVo.class;
    }

    public List<BusinessPolicyProductDto> findDtoListFromRepository(BusinessPolicyProductDto dto, String cacheKey) {
        if (StringUtils.isEmpty((CharSequence)dto.getBusinessPolicyCode())) {
            return Lists.newArrayList();
        }
        return this.businessPolicyProductRepository.findListByCode(dto.getBusinessPolicyCode());
    }

    public List<BusinessPolicyProductDto> newItem(String cacheKey, List<BusinessPolicyProductDto> itemList) {
        itemList.forEach(newItem -> {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        });
        return itemList;
    }

    public List<BusinessPolicyProductDto> copyItem(String cacheKey, List<BusinessPolicyProductDto> itemList) {
        List newItemList = (List)this.nebulaToolkitService.copyCollectionByBlankList(itemList, BusinessPolicyProductDto.class, BusinessPolicyProductDto.class, HashSet.class, ArrayList.class, new String[0]);
        for (BusinessPolicyProductDto newItem : newItemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }
        return newItemList;
    }

    public Object getDtoKey(BusinessPolicyProductDto dto) {
        return dto.getId();
    }

    public String getCheckedStatus(BusinessPolicyProductDto dto) {
        return dto.getChecked();
    }

    public void filterSaveItem(String cacheKey, List<Object> idList, List<BusinessPolicyProductDto> itemList, List<BusinessPolicyProductDto> updateList) {
        List productCodes = updateList.stream().map(BusinessPolicyProductDto::getProductCode).collect(Collectors.toList());
        itemList = itemList.stream().filter(item -> !idList.contains(this.getDtoKey((BusinessPolicyProductDto)item))).filter(item -> !productCodes.contains(item.getProductCode())).collect(Collectors.toList());
    }
}

