/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.business.policy.local.imports;

import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.tpm.business.business.policy.local.imports.vo.BusinessPolicyScopeImportVo;
import com.biz.crm.tpm.business.business.policy.sdk.dto.BusinessPolicyScopeDto;
import com.bizunited.nebula.common.util.JsonUtils;
import com.google.common.collect.Lists;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BusinessPolicyScopeImportProcess
implements ImportProcess<BusinessPolicyScopeImportVo> {
    private static final Logger log = LoggerFactory.getLogger(BusinessPolicyScopeImportProcess.class);
    @Autowired(required=false)
    private RedisService redisService;

    public Map<Integer, String> execute(LinkedHashMap<Integer, BusinessPolicyScopeImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        String cacheKey = (String)params.get("cacheKey");
        Validate.isTrue((!StringUtils.isEmpty((CharSequence)cacheKey) ? 1 : 0) != 0, (String)"\u7f13\u5b58key\u4e0d\u80fd\u7a7a", (Object[])new Object[0]);
        log.info("\u5546\u52a1\u653f\u7b56\u5bfc\u5165\u6570\u636e{}", (Object)JsonUtils.obj2JsonString(data.values()));
        List<BusinessPolicyScopeDto> buildData = this.buildData(data);
        log.info("\u5546\u52a1\u653f\u7b56\u5bfc\u5165\u6784\u5efa\u540e\u6570\u636e{}", (Object)JsonUtils.obj2JsonString(buildData));
        this.redisService.set("business_policy:scope:" + cacheKey, buildData, 300L);
        return null;
    }

    private List<BusinessPolicyScopeDto> buildData(LinkedHashMap<Integer, BusinessPolicyScopeImportVo> data) {
        ArrayList<BusinessPolicyScopeDto> businessPolicyScopeDtos = new ArrayList<BusinessPolicyScopeDto>();
        try {
            ArrayList policyScopeImportVos = Lists.newArrayList(data.values());
            Map<String, List<BusinessPolicyScopeImportVo>> policyScopeImportMap = policyScopeImportVos.stream().collect(Collectors.groupingBy(BusinessPolicyScopeImportVo::getCustomerGrade));
            policyScopeImportMap.forEach((key, value) -> Validate.isTrue((value.size() <= 1 ? 1 : 0) != 0, (String)"\u4ea7\u54c1\u7b49\u7ea7\u3010%s\u3011\u5f55\u5165\u91cd\u590d", (Object[])new Object[]{key}));
            for (BusinessPolicyScopeImportVo item : policyScopeImportVos) {
                BusinessPolicyScopeDto businessPolicyScopeDto = new BusinessPolicyScopeDto();
                BeanUtils.copyProperties((Object)item, (Object)businessPolicyScopeDto);
                this.amountTransform(item, businessPolicyScopeDto);
                businessPolicyScopeDtos.add(businessPolicyScopeDto);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            String errorMsg = e.getMessage();
            if (StringUtils.isEmpty((CharSequence)e.getMessage())) {
                errorMsg = "\u6570\u636e\u5904\u7406\u5931\u8d25\uff01";
            }
            throw new IllegalArgumentException(errorMsg);
        }
        return businessPolicyScopeDtos;
    }

    private void amountTransform(BusinessPolicyScopeImportVo item, BusinessPolicyScopeDto dto) throws InvocationTargetException, IllegalAccessException {
        PropertyDescriptor[] bpsis = BeanUtils.getPropertyDescriptors(BusinessPolicyScopeImportVo.class);
        PropertyDescriptor[] bpsds = BeanUtils.getPropertyDescriptors(BusinessPolicyScopeDto.class);
        Map bpsdsMap = Arrays.stream(bpsds).collect(Collectors.toMap(FeatureDescriptor::getName, Function.identity()));
        for (PropertyDescriptor bpsi : bpsis) {
            Object bpsiValue = bpsi.getReadMethod().invoke((Object)item, new Object[0]);
            if (Objects.isNull(bpsiValue)) continue;
            String propertyName = bpsi.getName();
            PropertyDescriptor bpsd = (PropertyDescriptor)bpsdsMap.get(propertyName);
            if (bpsi.getPropertyType().equals(bpsd.getPropertyType()) || !bpsi.getPropertyType().equals(String.class) || !bpsd.getPropertyType().equals(BigDecimal.class)) continue;
            bpsd.getWriteMethod().invoke((Object)dto, new BigDecimal((String)bpsiValue));
        }
    }

    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    public Class<BusinessPolicyScopeImportVo> findCrmExcelVoClass() {
        return BusinessPolicyScopeImportVo.class;
    }

    public String getTemplateCode() {
        return "business_policy_scope_import_process";
    }

    public String getTemplateName() {
        return "\u4fc3\u9500\u653f\u7b56\u8303\u56f4\u5bfc\u5165";
    }

    public List<BusinessPolicyScopeDto> getPolicyScope(String cacheKey) {
        log.info("\u4fc3\u9500\u653f\u7b56\u8303\u56f4\u5bfc\u5165\u67e5\u8be2\u6570\u636e:cacheKey:{}", (Object)cacheKey);
        List o = (List)this.redisService.get("business_policy:scope:" + cacheKey);
        log.info("\u4fc3\u9500\u653f\u7b56\u8303\u56f4\u5bfc\u5165\u67e5\u8be2\u6570\u636e:o:{}", (Object)JsonUtils.obj2JsonString((Object)o));
        return o;
    }
}

