/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.business.policy.local.imports;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import com.biz.crm.tpm.business.business.policy.local.imports.vo.PolicyProductImportVo;
import com.biz.crm.tpm.business.business.policy.local.service.BusinessPolicyProductService;
import com.biz.crm.tpm.business.business.policy.sdk.dto.BusinessPolicyProductDto;
import com.bizunited.nebula.common.util.JsonUtils;
import com.google.common.collect.Lists;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PolicyProductImportsProcess
implements ImportProcess<PolicyProductImportVo> {
    private static final Logger log = LoggerFactory.getLogger(PolicyProductImportsProcess.class);
    @Autowired(required=false)
    private BusinessPolicyProductService businessPolicyProductService;
    @Autowired(required=false)
    private ProductVoService productVoService;

    public Map<Integer, String> execute(LinkedHashMap<Integer, PolicyProductImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        String cacheKey = (String)params.get("cacheKey");
        Validate.isTrue((!StringUtils.isEmpty((CharSequence)cacheKey) ? 1 : 0) != 0, (String)"\u7f13\u5b58key\u4e0d\u80fd\u7a7a", (Object[])new Object[0]);
        log.info("\u5546\u52a1\u653f\u7b56\u5bfc\u5165\u6570\u636e{}", (Object)JsonUtils.obj2JsonString(data.values()));
        List<BusinessPolicyProductDto> buildData = this.buildData(data);
        log.info("\u5546\u52a1\u653f\u7b56\u5bfc\u5165\u6784\u5efa\u540e\u6570\u636e{}", (Object)JsonUtils.obj2JsonString(buildData));
        this.businessPolicyProductService.saveListCache(cacheKey, buildData);
        return null;
    }

    private List<BusinessPolicyProductDto> buildData(LinkedHashMap<Integer, PolicyProductImportVo> data) {
        ArrayList<BusinessPolicyProductDto> businessPolicyProductDtoList = new ArrayList<BusinessPolicyProductDto>();
        try {
            ArrayList policyProductImportVos = Lists.newArrayList(data.values());
            List productList = policyProductImportVos.stream().map(PolicyProductImportVo::getProductCode).collect(Collectors.toList());
            List productVoList = this.productVoService.findByProductCodes(productList);
            Map productVoMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity(), (o, n) -> n));
            policyProductImportVos.forEach(item -> {
                Validate.notBlank((CharSequence)item.getProductCode(), (String)"\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notNull(productVoMap.get(item.getProductCode()), (String)"\u4ea7\u54c1\u7f16\u7801\u3010%s\u3011\u672a\u627e\u5230", (Object[])new Object[]{item.getProductCode()});
            });
            Map<String, List<PolicyProductImportVo>> policyProductImportMap = policyProductImportVos.stream().collect(Collectors.groupingBy(PolicyProductImportVo::getProductCode));
            policyProductImportMap.forEach((key, value) -> Validate.isTrue((value.size() <= 1 ? 1 : 0) != 0, (String)"\u4ea7\u54c1\u7f16\u7801\u3010%s\u3011\u5f55\u5165\u91cd\u590d", (Object[])new Object[]{key}));
            for (PolicyProductImportVo item2 : policyProductImportVos) {
                ProductVo productVo = (ProductVo)productVoMap.get(item2.getProductCode());
                BusinessPolicyProductDto dto = new BusinessPolicyProductDto();
                BeanUtils.copyProperties((Object)item2, (Object)dto);
                PolicyProductImportsProcess.amountTransform(item2, dto);
                dto.setId(UuidCrmUtil.general());
                dto.setProductBrandCode(productVo.getProductBrandCode());
                dto.setProductBrandName(productVo.getProductBrandName());
                dto.setProductCategoryCode(productVo.getProductCategoryCode());
                dto.setProductCategoryName(productVo.getProductCategoryName());
                dto.setProductCode(productVo.getProductCode());
                dto.setProductName(productVo.getProductName());
                if (Objects.nonNull(dto.getOfferGoodsPrice()) && Objects.nonNull(dto.getPredictSaleQuantity())) {
                    BigDecimal amount = dto.getOfferGoodsPrice().multiply(dto.getPredictSaleQuantity());
                    dto.setPredictBeforeDiscountSaleAmount(dto.getOfferGoodsPrice().multiply(dto.getPredictSaleQuantity()));
                    if (Objects.nonNull(dto.getTenDayReturnPoint())) {
                        dto.setBaseReturnPointTenDayReturnFee(dto.getTenDayReturnPoint().multiply(amount));
                    }
                    if (Objects.nonNull(dto.getMonthReturnPoint())) {
                        dto.setBaseReturnPointMonthReturnFee(dto.getMonthReturnPoint().multiply(amount));
                    }
                    if (Objects.nonNull(dto.getTargetReachReturnPoint())) {
                        dto.setTargetReachReturnPointFee(dto.getTargetReachReturnPoint().multiply(amount));
                    }
                    if (Objects.nonNull(dto.getCombinationPoint())) {
                        dto.setCombinationFee(dto.getCombinationPoint().multiply(amount));
                    }
                    if (Objects.nonNull(dto.getBaseOperationPoint())) {
                        dto.setBaseOperationFee(dto.getBaseOperationPoint().multiply(amount));
                    }
                    if (Objects.nonNull(dto.getManPoint())) {
                        dto.setPeopleFee(dto.getManPoint().multiply(amount));
                    }
                    if (Objects.nonNull(dto.getPutPoint())) {
                        dto.setPutFee(dto.getPutPoint().multiply(amount));
                    }
                    if (Objects.nonNull(dto.getLogisticPoint())) {
                        dto.setLogisticSupportFee(dto.getLogisticPoint().multiply(amount));
                    }
                    if (Objects.nonNull(dto.getQuarterReturnPoint())) {
                        dto.setQuarterReturnFee(dto.getQuarterReturnPoint().multiply(amount));
                    }
                    if (Objects.nonNull(dto.getYearReturnPoint())) {
                        dto.setYearReturnFee(dto.getYearReturnPoint().multiply(amount));
                    }
                    if (Objects.nonNull(dto.getOtherPolicy1Point())) {
                        dto.setOtherPolicy1Fee(dto.getOtherPolicy1Point().multiply(amount));
                    }
                    if (Objects.nonNull(dto.getOtherPolicy2Point())) {
                        dto.setOtherPolicy2Fee(dto.getOtherPolicy2Point().multiply(amount));
                    }
                    if (Objects.nonNull(dto.getOtherPolicy3Point())) {
                        dto.setOtherPolicy3Fee(dto.getOtherPolicy3Point().multiply(amount));
                    }
                }
                if (Objects.nonNull(dto.getOtherPolicy4Price()) && Objects.nonNull(dto.getPredictSaleQuantity())) {
                    dto.setOtherPolicy4Price(dto.getOtherPolicy4Price().multiply(dto.getPredictSaleQuantity()));
                }
                dto.setFeeTotal(Optional.ofNullable(dto.getBaseReturnPointTenDayReturnFee()).orElse(BigDecimal.ZERO).multiply(Optional.ofNullable(dto.getBaseReturnPointMonthReturnFee()).orElse(BigDecimal.ZERO)).multiply(Optional.ofNullable(dto.getTargetReachReturnPointFee()).orElse(BigDecimal.ZERO)).multiply(Optional.ofNullable(dto.getCombinationFee()).orElse(BigDecimal.ZERO)).multiply(Optional.ofNullable(dto.getBaseOperationFee()).orElse(BigDecimal.ZERO)).multiply(Optional.ofNullable(dto.getPeopleFee()).orElse(BigDecimal.ZERO)).multiply(Optional.ofNullable(dto.getPutFee()).orElse(BigDecimal.ZERO)).multiply(Optional.ofNullable(dto.getLogisticSupportFee()).orElse(BigDecimal.ZERO)).multiply(Optional.ofNullable(dto.getQuarterReturnFee()).orElse(BigDecimal.ZERO)).multiply(Optional.ofNullable(dto.getYearReturnFee()).orElse(BigDecimal.ZERO)).multiply(Optional.ofNullable(dto.getOtherPolicy1Fee()).orElse(BigDecimal.ZERO)).multiply(Optional.ofNullable(dto.getOtherPolicy2Fee()).orElse(BigDecimal.ZERO)).multiply(Optional.ofNullable(dto.getOtherPolicy3Fee()).orElse(BigDecimal.ZERO)).multiply(Optional.ofNullable(dto.getOtherPolicy4Price()).orElse(BigDecimal.ZERO)));
                businessPolicyProductDtoList.add(dto);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            String errorMsg = e.getMessage();
            if (StringUtils.isEmpty((CharSequence)e.getMessage())) {
                errorMsg = "\u6570\u636e\u5904\u7406\u5931\u8d25\uff01";
            }
            throw new IllegalArgumentException(errorMsg);
        }
        return businessPolicyProductDtoList;
    }

    private static void amountTransform(PolicyProductImportVo item, BusinessPolicyProductDto dto) throws InvocationTargetException, IllegalAccessException {
        PropertyDescriptor[] ppivs = BeanUtils.getPropertyDescriptors(PolicyProductImportVo.class);
        PropertyDescriptor[] bppds = BeanUtils.getPropertyDescriptors(BusinessPolicyProductDto.class);
        Map bppdsMap = Arrays.stream(bppds).collect(Collectors.toMap(FeatureDescriptor::getName, Function.identity()));
        for (PropertyDescriptor ppiv : ppivs) {
            Object ppivValue = ppiv.getReadMethod().invoke((Object)item, new Object[0]);
            if (Objects.isNull(ppivValue)) continue;
            String propertyName = ppiv.getName();
            PropertyDescriptor bppd = (PropertyDescriptor)bppdsMap.get(propertyName);
            if (ppiv.getPropertyType().equals(bppd.getPropertyType()) || !ppiv.getPropertyType().equals(String.class) || !bppd.getPropertyType().equals(BigDecimal.class)) continue;
            bppd.getWriteMethod().invoke((Object)dto, new BigDecimal((String)ppivValue));
        }
    }

    public static void main(String[] args) throws InvocationTargetException, IllegalAccessException {
        PolicyProductImportVo policyProductImportVo = new PolicyProductImportVo();
        policyProductImportVo.setOfferGoodsPrice("10.01");
        BusinessPolicyProductDto businessPolicyProductDto = new BusinessPolicyProductDto();
        PolicyProductImportsProcess.amountTransform(policyProductImportVo, businessPolicyProductDto);
        log.info(JsonUtils.obj2JsonString((Object)businessPolicyProductDto));
    }

    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    public Class<PolicyProductImportVo> findCrmExcelVoClass() {
        return PolicyProductImportVo.class;
    }

    public String getTemplateCode() {
        return "POLICY_CUSTOMER_IMPORT";
    }

    public String getTemplateName() {
        return "\u5546\u52a1\u653f\u7b56\u4ea7\u54c1\u5bfc\u5165";
    }
}

