/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.business.policy.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.business.policy.local.entity.BusinessPolicyBudget;
import com.biz.crm.tpm.business.business.policy.local.repository.BusinessPolicyBudgetRepository;
import com.biz.crm.tpm.business.business.policy.local.service.BusinessPolicyBudgetService;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="businessPolicyBudgetService")
public class BusinessPolicyBudgetServiceImpl
implements BusinessPolicyBudgetService {
    @Autowired
    private BusinessPolicyBudgetRepository businessPolicyBudgetRepository;

    @Override
    public Page<BusinessPolicyBudget> findByConditions(Pageable pageable, BusinessPolicyBudget businessPolicyBudget) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull((Object)businessPolicyBudget)) {
            businessPolicyBudget = new BusinessPolicyBudget();
        }
        return this.businessPolicyBudgetRepository.findByConditions(pageable, businessPolicyBudget);
    }

    @Override
    public BusinessPolicyBudget findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (BusinessPolicyBudget)((Object)this.businessPolicyBudgetRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional
    public BusinessPolicyBudget create(BusinessPolicyBudget businessPolicyBudget) {
        this.createValidate(businessPolicyBudget);
        this.businessPolicyBudgetRepository.saveOrUpdate((Object)businessPolicyBudget);
        return businessPolicyBudget;
    }

    @Override
    @Transactional
    public BusinessPolicyBudget update(BusinessPolicyBudget businessPolicyBudget) {
        this.updateValidate(businessPolicyBudget);
        this.businessPolicyBudgetRepository.saveOrUpdate((Object)businessPolicyBudget);
        return businessPolicyBudget;
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.businessPolicyBudgetRepository.removeByIds(idList);
    }

    private void createValidate(BusinessPolicyBudget businessPolicyBudget) {
        Validate.notNull((Object)((Object)businessPolicyBudget), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        businessPolicyBudget.setId(null);
        Validate.notBlank((CharSequence)businessPolicyBudget.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)businessPolicyBudget.getFeeBelongCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8d39\u7528\u5f52\u53e3[\u6570\u636e\u5b57\u5178:tpm_fee_belong] \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(BusinessPolicyBudget businessPolicyBudget) {
        Validate.notNull((Object)((Object)businessPolicyBudget), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)businessPolicyBudget.getId(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)businessPolicyBudget.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)businessPolicyBudget.getFeeBelongCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8d39\u7528\u5f52\u53e3[\u6570\u636e\u5b57\u5178:tpm_fee_belong] \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

