/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.business.policy.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.business.policy.sdk.service.BusinessPolicyLockService;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class BusinessPolicyLockServiceImpl
implements BusinessPolicyLockService {
    private static final Logger log = LoggerFactory.getLogger(BusinessPolicyLockServiceImpl.class);
    @Autowired(required=false)
    private RedisLockService redisLockService;

    public boolean lock(String code, TimeUnit timeUnit, int time) {
        Assert.hasLength((String)code, (String)"\u5546\u52a1\u653f\u7b56\u52a0\u9501\u5931\u8d25\uff0c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        return this.lock(Collections.singletonList(code), timeUnit, time);
    }

    public boolean lock(List<String> codeList, TimeUnit timeUnit, int time) {
        Assert.notEmpty(codeList, (String)"\u5546\u52a1\u653f\u7b56\u52a0\u9501\u5931\u8d25\uff0c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        if (Objects.isNull((Object)timeUnit)) {
            timeUnit = TimeUnit.MINUTES;
        }
        if (time < 1) {
            time = 3;
        }
        return this.redisLockService.batchLock("tpm:business_policy:lock:", codeList, timeUnit, time);
    }

    public void unlock(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return;
        }
        this.unlock(Collections.singletonList(code));
    }

    public void unlock(List<String> codeList) {
        if (CollectionUtil.isEmpty(codeList)) {
            return;
        }
        this.redisLockService.batchUnLock("tpm:business_policy:lock:", codeList);
    }
}

